/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.TabWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.ButtonTabComponent;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.DockTabDesktopPane;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.DockTabDesktopPaneHolder;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.DockTabDesktopPaneListener;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.RemoveTabHandelResult;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.SmallTabButton;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.TabHandle;
import net.sourceforge.squirrel_sql.client.gui.mainframe.SquirrelDesktopManager;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class TabWindowController
implements DockTabDesktopPaneHolder {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DockTabDesktopPaneHolder.class);
    private final DockTabDesktopPane _dockTabDesktopPane;
    private IApplication _app;
    private final JMenu _mnuSession;
    private final JFrame _tabWindowFrame;

    public TabWindowController(Point locationOnScreen, Dimension size, final IApplication app) {
        this._app = app;
        this._tabWindowFrame = new JFrame(this._app.getMainFrame().getTitle() + " " + s_stringMgr.getString("docktabdesktop.TabWindowController.titlePostFix"));
        this._tabWindowFrame.setLocation(locationOnScreen);
        this._tabWindowFrame.setSize(size);
        this._tabWindowFrame.setDefaultCloseOperation(2);
        DockTabDesktopPaneListener dockTabDesktopPaneListener = new DockTabDesktopPaneListener(){

            @Override
            public void tabWasRemoved(TabHandle tabHandle) {
                TabWindowController.this.onTabWasRemoved();
            }
        };
        this._dockTabDesktopPane = new DockTabDesktopPane(app, false, dockTabDesktopPaneListener);
        this._dockTabDesktopPane.setDesktopManager(new SquirrelDesktopManager(app));
        this._tabWindowFrame.getContentPane().add(this._dockTabDesktopPane);
        JMenuBar mnuBar = new JMenuBar();
        this._mnuSession = this.cloneMenu(app.getMainFrame().getSessionMenu());
        mnuBar.add(this._mnuSession);
        this._tabWindowFrame.setJMenuBar(mnuBar);
        WindowFocusListener l = new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                TabWindowController.this.onWindowFocusGained(app);
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        };
        this._tabWindowFrame.addWindowFocusListener(l);
        ImageIcon icon = app.getResources().getIcon("AppIcon");
        if (icon != null) {
            this._tabWindowFrame.setIconImage(icon.getImage());
        }
        this._tabWindowFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TabWindowController.this.onWindowClosing();
            }
        });
        this._tabWindowFrame.setDefaultCloseOperation(0);
        this._tabWindowFrame.setVisible(true);
    }

    private void onTabWasRemoved() {
        if (0 == this._dockTabDesktopPane.getTabCount()) {
            this.closeFrame();
        }
    }

    private void onWindowClosing() {
        this.dispose();
    }

    private void dispose() {
        TabHandle[] clone;
        ArrayList<TabHandle> handels = this._dockTabDesktopPane.getAllHandels();
        for (TabHandle handel : clone = handels.toArray(new TabHandle[handels.size()])) {
            if (handel.removeTab(DockTabDesktopPane.TabClosingMode.DISPOSE)) continue;
            return;
        }
        this._tabWindowFrame.setVisible(false);
        this._tabWindowFrame.dispose();
        this._app.getMultipleWindowsHandler().unregisterDesktop(this);
    }

    @Override
    public void setSelected(boolean b) {
        this._dockTabDesktopPane.setSelected(true);
        this.adjustSessionMenu();
    }

    private void adjustSessionMenu() {
        if (null == this._dockTabDesktopPane.getSelectedWidget()) {
            this._mnuSession.setEnabled(false);
        } else {
            this._mnuSession.setEnabled(true);
        }
    }

    @Override
    public void tabDragedAndDroped() {
        this.adjustSessionMenu();
    }

    private void onWindowFocusGained(IApplication app) {
        app.getMultipleWindowsHandler().selectDesktop(this);
    }

    private JMenu cloneMenu(JMenu menu) {
        JMenu ret = new JMenu(menu.getText());
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem toClone = menu.getItem(i);
            if (toClone instanceof JMenu) {
                ret.add(this.cloneMenu((JMenu)toClone));
                continue;
            }
            if (toClone instanceof JMenuItem) {
                JMenuItem clone = new JMenuItem(toClone.getText(), toClone.getIcon());
                clone.setMnemonic(toClone.getMnemonic());
                clone.setAction(toClone.getAction());
                clone.setAccelerator(toClone.getAccelerator());
                clone.setToolTipText(toClone.getToolTipText());
                ret.add(clone);
                continue;
            }
            ret.addSeparator();
        }
        return ret;
    }

    @Override
    public void addTabWidgetAt(TabWidget widget, int tabIndex, ArrayList<SmallTabButton> externalButtons, boolean widgetMovedButNotCreated) {
        SmallTabButton<Class<MoveTabBackToMainWinMarker>> btnMoveTabBackToMainWin = null;
        for (SmallTabButton<Class<MoveTabBackToMainWinMarker>> smallTabButton : externalButtons) {
            if (smallTabButton.getUserObject() != MoveTabBackToMainWinMarker.class) continue;
            btnMoveTabBackToMainWin = smallTabButton;
            break;
        }
        ArrayList<SmallTabButton<Object>> buf = externalButtons;
        if (null == btnMoveTabBackToMainWin) {
            buf = new ArrayList();
            String string = s_stringMgr.getString("docktabdesktop.TabWindowController.moveTabBackToMainWin");
            ImageIcon icon = this._app.getResources().getIcon("tabDetachSmallRevert");
            btnMoveTabBackToMainWin = new SmallTabButton<Class<MoveTabBackToMainWinMarker>>(string, icon, MoveTabBackToMainWinMarker.class);
            buf.add(btnMoveTabBackToMainWin);
            buf.addAll(externalButtons);
        }
        final TabHandle tabHandle = this._dockTabDesktopPane.addTabWidgetAt(widget, tabIndex, buf, widgetMovedButNotCreated);
        btnMoveTabBackToMainWin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabWindowController.this.onMoveBackToMainWin(tabHandle);
            }
        });
    }

    private void onMoveBackToMainWin(TabHandle tabHandle) {
        RemoveTabHandelResult removeTabHandelResult = this._dockTabDesktopPane.removeTabHandel(tabHandle);
        this.cleanUpOnMove(removeTabHandelResult);
        DockTabDesktopPaneHolder mainDockTabDesktopHolder = this._app.getMultipleWindowsHandler().getMainDockTabDesktopHolder();
        ButtonTabComponent removedButtonTabComponent = removeTabHandelResult.getRemovedButtonTabComponent();
        if (null != removedButtonTabComponent) {
            ArrayList<SmallTabButton> externalButtons = removedButtonTabComponent.getExternalButtons();
            mainDockTabDesktopHolder.addTabWidget(tabHandle.getWidget(), externalButtons, true);
        }
    }

    @Override
    public RemoveTabHandelResult removeTabHandel(int tabIndex) {
        RemoveTabHandelResult tabHandelResult = this._dockTabDesktopPane.removeTabHandel(tabIndex);
        this.cleanUpOnMove(tabHandelResult);
        return tabHandelResult;
    }

    private void cleanUpOnMove(RemoveTabHandelResult tabHandelResult) {
        ButtonTabComponent removedButtonTabComponent = tabHandelResult.getRemovedButtonTabComponent();
        SmallTabButton stb = null;
        if (null != removedButtonTabComponent) {
            stb = removedButtonTabComponent.findSmallTabButtonByUserObject(MoveTabBackToMainWinMarker.class);
        }
        if (null != stb) {
            for (ActionListener actionListener : stb.getActionListeners()) {
                stb.removeActionListener(actionListener);
            }
            removedButtonTabComponent.removeSmallTabButton(stb);
        }
        if (0 == this._dockTabDesktopPane.getTabCount()) {
            this.closeFrame();
        }
    }

    private void closeFrame() {
        this.dispose();
        this._tabWindowFrame.setVisible(false);
        this._tabWindowFrame.dispose();
    }

    @Override
    public boolean isMyTabbedPane(JTabbedPane tabbedPane) {
        return this._dockTabDesktopPane.isMyTabbedPane(tabbedPane);
    }

    @Override
    public void addTabWidget(TabWidget widget, ArrayList<SmallTabButton> externalButtons, boolean widgetMovedButNotCreated) {
        this._dockTabDesktopPane.addTabWidgetAt(widget, this._dockTabDesktopPane.getTabCount(), externalButtons, widgetMovedButNotCreated);
    }

    private static class MoveTabBackToMainWinMarker {
        private MoveTabBackToMainWinMarker() {
        }
    }
}

