/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.sql.SQLException;
import unity.engine.Tuple;
import unity.operators.Operator;
import unity.predicates.SelectionPredicate;
import unity.query.LQNode;

public class Selection
extends Operator {
    private static final long serialVersionUID = 1L;
    protected SelectionPredicate predicate;
    private Operator input;

    public Selection(Operator operator, SelectionPredicate selectionPredicate) {
        this(operator, selectionPredicate, null);
    }

    public Selection(Operator operator, SelectionPredicate selectionPredicate, LQNode lQNode) {
        super(new Operator[]{operator}, 0L);
        this.input = operator;
        this.queryNode = lQNode;
        this.predicate = selectionPredicate;
        this.setOutputRelation(this.input.getOutputRelation());
    }

    @Override
    public void init() throws SQLException {
        this.input.init();
    }

    @Override
    public boolean next(Tuple tuple) throws SQLException {
        while (this.input.next(tuple)) {
            if (!this.predicate.evaluate(tuple)) continue;
            this.incrementRowsOut();
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(250);
        stringBuilder.append("SELECT: ");
        if (this.predicate != null) {
            stringBuilder.append(this.predicate.toString(this.outputRelation));
        }
        return stringBuilder.toString();
    }

    public SelectionPredicate getPredicate() {
        return this.predicate;
    }

    public void setPredicate(SelectionPredicate selectionPredicate) {
        this.predicate = selectionPredicate;
    }

    @Override
    public String getName() {
        return "SELECTION";
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    @Override
    public double getCost() {
        long l = this.input.getRows();
        return (double)l * 1.0;
    }
}

