/*
 * Decompiled with CFR 0.152.
 */
package snow.conn;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import snow.conn.RequestThread;
import snow.conn.SNowExecutor;
import snow.conn.SoapResultParser;
import snow.jdbc.SNowStatement;
import unity.annotation.AnnotatedSourceDatabase;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceForeignKey;
import unity.annotation.AnnotatedSourceKey;
import unity.annotation.GlobalSchema;
import unity.annotation.SourceDatabase;
import unity.annotation.SourceField;
import unity.annotation.SourceForeignKey;
import unity.annotation.SourceTable;
import unity.engine.Attribute;
import unity.engine.IServerConnection;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.io.FileManager;
import unity.jdbc.LocalResultSet;
import unity.jdbc.UnityConnection;
import unity.jdbc.UnityDriver;
import unity.jdbc.UnityStatement;
import unity.query.GlobalQuery;
import unity.query.Optimizer;
import unity.util.SecureAuthenticator;

public class ServerConnection
implements IServerConnection {
    private String url;
    private String userName;
    private Properties properties;
    private UnityConnection uconn;
    private SourceDatabase database;
    private GlobalSchema schema;
    private String schemaLocation;
    private Connection connection;
    private int lastStatementId = 0;
    private HashMap<Integer, SNowExecutor> executors;

    public ServerConnection(String string, Connection connection) {
        this.url = string;
        this.uconn = null;
        this.connection = connection;
        this.executors = new HashMap();
    }

    @Override
    public void connect(Properties properties) throws SQLException {
        try {
            String string;
            this.properties = properties;
            String string2 = properties.getProperty("user");
            if (string2 == null) {
                string2 = "admin";
            }
            if ((string = properties.getProperty("password")) == null) {
                string = "admin";
            }
            SecureAuthenticator secureAuthenticator = SecureAuthenticator.getInstance();
            try {
                secureAuthenticator.register(new URL("https://" + this.url + ":443"), new PasswordAuthentication(string2, string.toCharArray()));
                Authenticator.setDefault(secureAuthenticator);
            }
            catch (Exception exception) {
                throw new SQLException("Error authenticating with ServiceNow.  Check user id and password.\n" + exception);
            }
            Object object = this.properties.get("rebuildschema");
            this.schemaLocation = (String)this.properties.get("schema");
            if (object != null && object.toString().equalsIgnoreCase("true")) {
                this.buildSchema();
            } else if (this.schemaLocation != null) {
                this.schema = new GlobalSchema();
                if (!this.loadSchema(this.schemaLocation)) {
                    this.schema = null;
                }
            }
            if (this.schema == null) {
                this.buildSchema();
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    public ResultSet getMoreResults(int n, SNowStatement sNowStatement) throws SQLException {
        try {
            return null;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    private ResultSet processQueryWithUnity(String string, GlobalSchema globalSchema, GlobalQuery globalQuery) throws SQLException {
        Object object;
        if (UnityDriver.DEBUG) {
            System.out.println("Processing query in UnityJDBC not handled by ServiceNow.");
        }
        if (this.uconn == null) {
            try {
                Class.forName("unity.jdbc.UnityDriver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SQLException(classNotFoundException);
            }
            object = new Properties();
            this.uconn = (UnityConnection)DriverManager.getConnection("jdbc:unity://virtual", (Properties)object);
        }
        this.uconn.setGlobalSchema(globalSchema);
        this.uconn.setConnection("servicenow", this.connection);
        object = (UnityStatement)this.uconn.createStatement();
        if (globalQuery == null) {
            globalQuery = ((UnityStatement)object).parseQuery(string, true);
        } else {
            Optimizer optimizer = new Optimizer(globalQuery, false, (UnityStatement)object);
            globalQuery = optimizer.optimize();
            globalQuery.setQueryString(string);
        }
        return ((UnityStatement)object).executeQuery(globalQuery);
    }

    public ResultSet executeQuery(String string, int n, SNowStatement sNowStatement) throws SQLException {
        try {
            if (string.contains("SELECT 1")) {
                ArrayList<ArrayList<Object>> arrayList = new ArrayList<ArrayList<Object>>();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>(1);
                arrayList2.add(1);
                arrayList.add(arrayList2);
                ArrayList<SourceField> arrayList3 = new ArrayList<SourceField>(1);
                arrayList3.add(new SourceField(null, null, null, "Field1", 4, "INT", 4, 0, 0, 0, "", null, 0, 1, "YES"));
                return new LocalResultSet(arrayList, new String[]{"Field1"}, arrayList3);
            }
            SNowExecutor sNowExecutor = new SNowExecutor(this.url, ++this.lastStatementId);
            this.executors.put(this.lastStatementId, sNowExecutor);
            try {
                return sNowExecutor.execute(string, n, sNowStatement, this.schema, this);
            }
            catch (SQLException sQLException) {
                return this.processQueryWithUnity(string, this.schema, sNowExecutor.getGlobalQuery());
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public boolean next(int n, Tuple tuple) throws SQLException {
        SNowExecutor sNowExecutor = this.executors.get(n);
        if (sNowExecutor == null) {
            return false;
        }
        return sNowExecutor.next(tuple);
    }

    @Override
    public boolean get(int n, int n2, Tuple tuple) throws SQLException {
        try {
            return false;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public int getLast(int n) throws SQLException {
        try {
            return 0;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public SourceDatabase getDatabase() {
        if (this.database == null) {
            try {
                this.buildSchema();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.database;
    }

    public GlobalSchema getSchema() throws SQLException {
        if (this.database == null) {
            this.buildSchema();
        }
        return this.schema;
    }

    public void buildSchema() throws SQLException {
        if (UnityDriver.DEBUG) {
            System.out.println("Building schema");
        }
        this.database = this.buildSourceDatabase();
        if (this.schema == null) {
            this.schema = new GlobalSchema();
        }
        this.schema.addDatabase(this.database);
        this.schema.linkForeignKeysAndJoinsAll();
        this.saveSchema(this.schemaLocation);
    }

    public SourceDatabase buildSourceDatabase() throws SQLException {
        long l = System.currentTimeMillis();
        String string = "servicenow";
        AnnotatedSourceDatabase annotatedSourceDatabase = new AnnotatedSourceDatabase(string, string, "ServiceNow", "Calgary", "jdbc:snow://" + this.url, "snow.jdbc.SNowDriver", '\"');
        annotatedSourceDatabase.setJavaDriverClassName("snow.jdbc.SNowDriver");
        annotatedSourceDatabase.setDatabaseId(82030000);
        Attribute[] attributeArray = new Attribute[]{new Attribute("element", 12, 0), new Attribute("name", 12, 0), new Attribute("internal_type", 12, 0), new Attribute("reference", 12, 0)};
        Relation relation = new Relation(attributeArray);
        String string2 = "active,array,attributes,audit,calculation,choice,choice_field,choice_table,comments,create_roles,default_value,defaultsort,delete_roles,dependent,display,dynamic_creation,dynamic_creation_script,element_reference,foreign_database,mandatory,read_only,read_roles,reference_cascade_rule,reference_floats,reference_qual,reference_type,sizeclass,spell_check,sys_class_name,sys_created_by,sys_created_on,sys_mod_count,sys_updated_by,sys_updated_on,table_reference,text_index,u_relationship_type,unique,virtual,widget,write_roles,xml_view,sys_id";
        String string3 = "https://" + this.url + "/" + "sys_dictionary.do?SOAP";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("__limit", "50000");
        hashMap.put("__exclude_columns", string2);
        hashMap.put("__order_by", "name");
        ArrayList<Tuple> arrayList = ServerConnection.getRecords(string3, "sys_dictionary", hashMap, relation);
        if (UnityDriver.DEBUG) {
            System.out.println("Time to retrieve/process sys_dictionary: " + (System.currentTimeMillis() - l));
        }
        int n = relation.getAttributeIndexByName("element");
        int n2 = relation.getAttributeIndexByName("name");
        int n3 = relation.getAttributeIndexByName("internal_type");
        int n4 = relation.getAttributeIndexByName("reference");
        int n5 = 1;
        String string4 = "";
        HashMap<String, SourceField> hashMap2 = null;
        LinkedHashMap<String, SourceTable> linkedHashMap = new LinkedHashMap<String, SourceTable>();
        AnnotatedSourceKey annotatedSourceKey = null;
        ArrayList<SourceForeignKey> arrayList2 = new ArrayList<SourceForeignKey>();
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList<SourceField> arrayList3;
            Object object;
            String string5;
            Tuple tuple = arrayList.get(i);
            String string6 = tuple.getString(n2);
            if (!string4.equals(string6)) {
                if (!string4.equals("")) {
                    string5 = "https://" + this.url + "/" + string4 + ".do?WSDL";
                    while (!RequestThread.addThread()) {
                        Thread.yield();
                    }
                    object = new RequestThread(annotatedSourceDatabase, string4, string5, hashMap2, linkedHashMap, annotatedSourceKey, arrayList2);
                    ((Thread)object).start();
                }
                hashMap2 = new HashMap<String, SourceField>();
                n5 = 1;
                annotatedSourceKey = null;
                arrayList2 = new ArrayList();
                string4 = string6;
            }
            string5 = tuple.getString(n);
            object = tuple.getString(n3);
            if (string5 == null || object == null) continue;
            AnnotatedSourceField annotatedSourceField = new AnnotatedSourceField();
            annotatedSourceField.setColumnName(string5);
            object = ((String)object).toLowerCase();
            int n6 = 12;
            if (((String)object).equals("integer")) {
                n6 = 4;
            } else if (((String)object).equals("boolean") || ((String)object).equals("true/false")) {
                n6 = 16;
            } else if (((String)object).contains("time")) {
                n6 = 93;
            } else if (((String)object).contains("guid") || ((String)object).contains("sys id")) {
                n6 = 12;
                arrayList3 = new ArrayList<SourceField>();
                arrayList3.add(annotatedSourceField);
                annotatedSourceKey = new AnnotatedSourceKey(arrayList3, 1, "PK_" + string6);
            } else if (((String)object).contains("reference")) {
                n6 = 12;
                arrayList3 = new ArrayList();
                arrayList3.add((SourceField)((Object)string5));
                ArrayList<SourceField> arrayList4 = new ArrayList<SourceField>();
                arrayList4.add(annotatedSourceField);
                String string7 = tuple.getString(n4);
                AnnotatedSourceForeignKey annotatedSourceForeignKey = new AnnotatedSourceForeignKey(null, arrayList4, arrayList3, "FK_" + string7 + "_" + string5, string7);
                arrayList2.add(annotatedSourceForeignKey);
            }
            annotatedSourceField.setDataTypeName(Attribute.getTypeName(n6));
            annotatedSourceField.setDataType(n6);
            annotatedSourceField.setTableName(string6);
            annotatedSourceField.setOrdinalPosition(n5++);
            annotatedSourceField.setColumnSize(0);
            annotatedSourceField.setCharacterOctetLength(50);
            hashMap2.put(string5, annotatedSourceField);
        }
        while (RequestThread.getThreadCount() > 0) {
            Thread.yield();
        }
        annotatedSourceDatabase.setSourceTables(linkedHashMap);
        if (UnityDriver.DEBUG) {
            System.out.println("Schema extraction time: " + (System.currentTimeMillis() - l));
        }
        return annotatedSourceDatabase;
    }

    @Override
    public void setFetchSize(int n, int n2) {
    }

    public void saveSchema(String string) throws SQLException {
        try {
            File file = new File(string);
            this.database.exportXML(file);
        }
        catch (IOException iOException) {
            throw new SQLException("Error while saving schema to file: " + iOException);
        }
    }

    public boolean loadSchema(String string) throws SQLException {
        try {
            BufferedInputStream bufferedInputStream = FileManager.openInputFile(string);
            this.database = this.schema.importSchema(bufferedInputStream);
            this.schema.addDatabase(this.database);
            this.schema.linkForeignKeysAndJoinsAll();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static ArrayList<Tuple> getRecords(String string, String string2, HashMap<String, String> hashMap, Relation relation) {
        try {
            SOAPConnection sOAPConnection;
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage sOAPMessage = messageFactory.createMessage();
            SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
            SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
            sOAPEnvelope.addNamespaceDeclaration("x", "http://www.service-now.com/" + string2);
            SOAPBody sOAPBody = sOAPEnvelope.getBody();
            SOAPElement sOAPElement = sOAPBody.addChildElement("getRecords", "x");
            for (Map.Entry<String, String> object2 : hashMap.entrySet()) {
                sOAPConnection = sOAPElement.addChildElement(object2.getKey());
                sOAPConnection.addTextNode(object2.getValue());
            }
            SOAPConnectionFactory sOAPConnectionFactory = SOAPConnectionFactory.newInstance();
            sOAPConnection = sOAPConnectionFactory.createConnection();
            URL uRL = new URL(string);
            SOAPMessage sOAPMessage2 = sOAPConnection.call(sOAPMessage, (Object)uRL);
            sOAPBody = sOAPMessage2.getSOAPBody();
            SoapResultParser soapResultParser = new SoapResultParser(sOAPBody.getFirstChild(), relation);
            return soapResultParser.getRows();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

