/*
 * Decompiled with CFR 0.152.
 */
package mongodb.conn;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mongodb.conn.ServerConnection;
import mongodb.jdbc.MongoResultSet;
import mongodb.jdbc.MongoStatement;
import mongodb.query.MongoBuilder;
import mongodb.query.MongoSelectQuery;
import unity.annotation.GlobalSchema;
import unity.annotation.SourceField;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.engine.TableData;
import unity.engine.Tuple;
import unity.jdbc.LocalResultSet;
import unity.jdbc.UnityDriver;
import unity.parser.GlobalParser;
import unity.query.GlobalQuery;
import unity.query.LQTree;

public class MongoExecutor {
    private boolean resultSetComplete;
    private DBCursor cursor;
    private Relation relation;
    private ArrayList<DBObject> cachedObjects;
    private int statementId;
    private DB db;
    private MongoSelectQuery mq;
    private MongoStatement stmt;
    private static final double SAMPLE_FRACTION = 0.001;
    private static final int MIN_SIZE_TO_SAMPLE = 10;

    public MongoExecutor(DB dB, int n) {
        this.db = dB;
        this.statementId = n;
        this.mq = null;
    }

    public ResultSet execute(String string, int n, MongoStatement mongoStatement, GlobalSchema globalSchema, ServerConnection serverConnection, boolean bl) throws Exception {
        Object object;
        string = string + ";";
        GlobalParser globalParser = new GlobalParser(false, bl);
        GlobalQuery globalQuery = globalParser.parse(string, globalSchema);
        LQTree lQTree = globalQuery.getLogicalQueryTree();
        if (UnityDriver.DEBUG) {
            System.out.println("Logical query tree: \n");
            lQTree.print();
        }
        MongoBuilder mongoBuilder = new MongoBuilder(lQTree.getRoot());
        this.mq = (MongoSelectQuery)mongoBuilder.toMongoQuery();
        mongoStatement.setQuery(this.mq);
        if (UnityDriver.DEBUG) {
            System.out.println(this.mq.toString());
        }
        if ((object = this.mq.run(this.db)) instanceof Integer) {
            int n2 = (Integer)object;
            ArrayList<ArrayList<Object>> arrayList = new ArrayList<ArrayList<Object>>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>(1);
            arrayList2.add(n2);
            arrayList.add(arrayList2);
            ArrayList<SourceField> arrayList3 = new ArrayList<SourceField>(1);
            arrayList3.add(new SourceField(null, null, null, this.mq.fieldNames.get("Count(*)"), 4, "INT", 4, 0, 0, 0, "", null, 0, 1, "YES"));
            return new LocalResultSet(arrayList, new String[]{this.mq.fieldNames.get("Count(*)")}, arrayList3);
        }
        this.cachedObjects = new ArrayList();
        if (object instanceof DBCursor) {
            this.cursor = (DBCursor)object;
            for (int i = 0; i < 3 && this.cursor.hasNext(); ++i) {
                DBObject dBObject = this.cursor.next();
                BasicDBObject basicDBObject = new BasicDBObject();
                basicDBObject = MongoExecutor.flattenObject(dBObject, this.mq, null, (DBObject)basicDBObject);
                this.cachedObjects.add((DBObject)basicDBObject);
            }
            this.relation = this.buildRelation(this.mq, this.cachedObjects);
        } else if (object instanceof BasicDBList) {
            this.cursor = null;
            for (Object e : (BasicDBList)object) {
                BasicDBObject basicDBObject = new BasicDBObject(this.mq.distinctField.toString(), e);
                this.cachedObjects.add((DBObject)basicDBObject);
            }
            this.relation = this.buildDistinctRelation(this.mq, this.cachedObjects);
        }
        TableData tableData = new TableData(serverConnection, n != 1003, this.statementId);
        tableData.setRelation(this.relation);
        return new MongoResultSet(tableData, this.relation, n, mongoStatement);
    }

    private static DBObject flattenObject(DBObject dBObject, MongoSelectQuery mongoSelectQuery, Object object, DBObject dBObject2) {
        Map map = dBObject.toMap();
        Set set = map.keySet();
        for (Object k : set) {
            Object object2 = dBObject.get((String)k);
            String string = object == null ? (String)k : object + "." + k;
            if (object2 instanceof List) {
                dBObject2.put(string, object2);
                continue;
            }
            if (!(object2 instanceof DBObject)) {
                if (mongoSelectQuery != null && !mongoSelectQuery.fieldNames.isEmpty() && !mongoSelectQuery.fieldNames.containsKey(string)) continue;
                dBObject2.put(string, object2);
                continue;
            }
            dBObject2.put(string, object2);
            String string2 = object == null ? (String)k : object + "." + k;
            dBObject2 = MongoExecutor.flattenObject((DBObject)object2, mongoSelectQuery, string2, dBObject2);
        }
        return dBObject2;
    }

    public ResultSet execute(String string, int n, MongoStatement mongoStatement, GlobalSchema globalSchema, ServerConnection serverConnection) throws Exception {
        boolean bl = false;
        String string2 = mongoStatement.getConnection().getClientInfo("validation");
        if (string2 != null && string2.equalsIgnoreCase("strict")) {
            bl = true;
        }
        return this.execute(string, n, mongoStatement, globalSchema, serverConnection, bl);
    }

    public static Attribute[] getSchema(DBCollection dBCollection) {
        Attribute[] attributeArray = null;
        int n = MongoExecutor.numberToSample(dBCollection);
        attributeArray = n != -1 ? MongoExecutor.guessFromRandomRecords(dBCollection, MongoExecutor.numberToSample(dBCollection)) : MongoExecutor.guessFromAllRecords(dBCollection);
        return attributeArray;
    }

    private static int numberToSample(DBCollection dBCollection) {
        long l = dBCollection.count();
        if (l < 10L) {
            return -1;
        }
        return (int)Math.ceil((double)l * 0.001);
    }

    private static Attribute[] guessFromAllRecords(DBCollection dBCollection) {
        DBCursor dBCursor = dBCollection.find().limit(0);
        Attribute[] attributeArray = null;
        while (dBCursor.hasNext()) {
            BasicDBObject basicDBObject = (BasicDBObject)dBCursor.next();
            basicDBObject = (BasicDBObject)MongoExecutor.flattenObject((DBObject)basicDBObject, null, null, (DBObject)basicDBObject);
            attributeArray = MongoExecutor.supersetSchema(MongoExecutor.guessSchema(basicDBObject.toMap(), null, null), attributeArray);
        }
        dBCursor.close();
        return attributeArray;
    }

    private static Attribute[] guessFromRandomRecords(DBCollection dBCollection, int n) {
        long l = dBCollection.count();
        int n2 = (int)Math.round(Math.random() * (double)(l - (long)n));
        if (n2 < 0) {
            n2 = 0;
        }
        long l2 = n;
        if (l < (long)n) {
            l2 = l;
        }
        Attribute[] attributeArray = null;
        DBCursor dBCursor = dBCollection.find().skip(n2);
        int n3 = 0;
        while ((long)n3 < l2) {
            BasicDBObject basicDBObject = (BasicDBObject)dBCursor.next();
            basicDBObject = (BasicDBObject)MongoExecutor.flattenObject((DBObject)basicDBObject, null, null, (DBObject)basicDBObject);
            attributeArray = MongoExecutor.supersetSchema(MongoExecutor.guessSchema(basicDBObject.toMap(), null, null), attributeArray);
            ++n3;
        }
        dBCursor.close();
        return attributeArray;
    }

    public static Attribute[] guessSchema(Map<String, Object> map, String string) {
        return MongoExecutor.guessSchema(map, string, null);
    }

    public static Attribute[] guessSchema(Map<String, Object> map, String string, MongoSelectQuery mongoSelectQuery) {
        int n = 0;
        Attribute[] attributeArray = new Attribute[map.size()];
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string2;
            String string3 = entry.getKey();
            if (string != null) {
                string3 = string + string3;
            }
            Object object = entry.getValue();
            int n2 = Attribute.getType(object);
            String string4 = string3;
            String string5 = null;
            if (mongoSelectQuery != null && (string2 = mongoSelectQuery.fieldNames.get(string4)) != null) {
                string5 = string4;
                string4 = string2;
            }
            attributeArray[n++] = new Attribute(string4, n2, -1, string5);
        }
        return attributeArray;
    }

    private static int getLeastGeneralType(int n, int n2) {
        return n;
    }

    public static Attribute[] supersetSchema(Attribute[] attributeArray, Attribute[] attributeArray2) {
        if (attributeArray == null) {
            return attributeArray2;
        }
        if (attributeArray2 == null) {
            return attributeArray;
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(Arrays.asList(attributeArray2));
        int n = 0;
        for (Attribute attribute : attributeArray) {
            if (attribute == null) continue;
            boolean bl = false;
            for (Attribute attribute2 : arrayList) {
                if (attribute2 == null || !attribute.getName().equals(attribute2.getName())) continue;
                if (attribute.getType() != attribute2.getType()) {
                    attribute2.setType(MongoExecutor.getLeastGeneralType(attribute.getType(), attribute2.getType()));
                }
                bl = true;
                break;
            }
            if (!bl) {
                arrayList.add(n, attribute);
            }
            ++n;
        }
        return arrayList.toArray(new Attribute[arrayList.size()]);
    }

    public Attribute[] buildAttributeList(MongoSelectQuery mongoSelectQuery, ArrayList<DBObject> arrayList) {
        LinkedHashMap linkedHashMap;
        if (this.mq.projections != null && this.mq.projections.size() > 0) {
            linkedHashMap = new LinkedHashMap();
            for (String string : mongoSelectQuery.projections.keySet()) {
                if ((Integer)mongoSelectQuery.projections.get(string) == 0) continue;
                if (arrayList != null && arrayList.size() > 0) {
                    linkedHashMap.put(string, arrayList.get(0).get(string));
                    continue;
                }
                linkedHashMap.put(string, "");
            }
        } else if (arrayList != null && arrayList.size() > 0) {
            DBObject dBObject = arrayList.get(0);
            linkedHashMap = (LinkedHashMap)dBObject;
        } else {
            return MongoExecutor.guessFromRandomRecords(this.db.getCollection(mongoSelectQuery.collectionName), 10);
        }
        return MongoExecutor.guessSchema(linkedHashMap, null, mongoSelectQuery);
    }

    public Relation buildRelation(MongoSelectQuery mongoSelectQuery, ArrayList<DBObject> arrayList) {
        return new Relation(this.buildAttributeList(mongoSelectQuery, arrayList));
    }

    public Relation buildDistinctRelation(MongoSelectQuery mongoSelectQuery, ArrayList<DBObject> arrayList) {
        Attribute[] attributeArray = new Attribute[1];
        int n = arrayList.isEmpty() ? Attribute.getType(null) : Attribute.getType(arrayList.get(0));
        attributeArray[0] = new Attribute(this.mq.distinctField, n, -1, this.mq.fieldNames.get(this.mq.distinctField));
        return new Relation(attributeArray);
    }

    public boolean next(Tuple tuple) throws SQLException {
        if (this.resultSetComplete) {
            return false;
        }
        try {
            DBObject dBObject = null;
            if (this.cachedObjects.size() > 0) {
                dBObject = this.cachedObjects.get(0);
                this.cachedObjects.remove(0);
                this.convertToTuple(dBObject, this.relation, tuple);
                return true;
            }
            if (this.cursor != null && this.cursor.hasNext()) {
                BasicDBObject basicDBObject = new BasicDBObject();
                dBObject = MongoExecutor.flattenObject(this.cursor.next(), this.mq, null, (DBObject)basicDBObject);
                this.convertToTuple(dBObject, this.relation, tuple);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    public void convertToTuple(DBObject dBObject, Relation relation, Tuple tuple) throws SQLException {
        int n = relation.getNumAttributes();
        Object[] objectArray = tuple.getValues();
        if (objectArray == null || objectArray.length != n) {
            objectArray = new Object[n];
        }
        for (int i = 0; i < relation.getNumAttributes(); ++i) {
            Object object;
            Attribute attribute = relation.getAttribute(i);
            Object object2 = attribute.getReference();
            objectArray[i] = object2 != null ? dBObject.get(object2.toString()) : ((object = dBObject.get(relation.getAttribute(i).getName())) instanceof BasicDBList ? new ArrayList((BasicDBList)object) : (object instanceof BasicDBObject ? (BasicDBObject)object : object));
        }
        tuple.setValues(objectArray);
    }
}

