/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dataimport.importer.csv;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComponent;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.dataimport.gui.ImportFileDialogProps;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.FailedToInterpretHandler;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.IFileImporter;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.csv.CSVSettingsBean;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.csv.CSVSettingsPanel;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.csv.CsvReader;

public class CSVFileImporter
implements IFileImporter {
    private static final StringManager stringMgr = StringManagerFactory.getStringManager(CSVFileImporter.class);
    private CSVSettingsBean settings;
    private File importFile;
    private CsvReader reader = null;
    private boolean safetySwitch = true;
    private boolean _trimValues = true;
    private FailedToInterpretHandler _failedToInterpretHandler = new FailedToInterpretHandler();

    public CSVFileImporter(File importFile) {
        this.importFile = importFile;
        this.settings = new CSVSettingsBean();
        this.settings.setSeperator(ImportFileDialogProps.getCSVSeparator());
        this.settings.setDateFormat(ImportFileDialogProps.getCSVDateFormat());
    }

    @Override
    public boolean open() throws IOException {
        this.reset();
        return true;
    }

    @Override
    public boolean close() {
        if (this.reader != null) {
            this.reader.close();
        }
        return true;
    }

    @Override
    public String[][] getPreview(int noOfLines) throws IOException {
        int row;
        CsvReader csvReader = new CsvReader(new InputStreamReader((InputStream)new FileInputStream(this.importFile), this.settings.getImportCharset()), this.settings.getSeperator(), this._trimValues);
        String[][] data = new String[noOfLines][];
        int columns = -1;
        for (row = 0; csvReader.readRecord() && row < noOfLines; ++row) {
            if (columns == -1) {
                columns = csvReader.getColumnCount();
            }
            data[row] = new String[columns];
            for (int i = 0; i < columns; ++i) {
                data[row][i] = csvReader.get(i);
            }
        }
        csvReader.close();
        String[][] outData = new String[row][];
        for (int i = 0; i < row; ++i) {
            outData[i] = data[i];
        }
        return outData;
    }

    @Override
    public boolean next() throws IOException {
        return this.reader.readRecord();
    }

    @Override
    public boolean reset() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = new CsvReader(new InputStreamReader((InputStream)new FileInputStream(this.importFile), this.settings.getImportCharset()), this.settings.getSeperator(), this._trimValues);
        this.reader.setSafetySwitch(this.safetySwitch);
        return true;
    }

    @Override
    public String getString(int column) throws IOException {
        return this.reader.get(column);
    }

    @Override
    public Long getLong(int column) throws IOException {
        Double ret = this.getDouble(column);
        if (null == ret) {
            return null;
        }
        return ret.longValue();
    }

    @Override
    public Integer getInt(int column) throws IOException {
        Double ret = this.getDouble(column);
        if (null == ret) {
            return null;
        }
        return ret.intValue();
    }

    @Override
    public Double getDouble(int column) throws IOException {
        String doubleS = this.reader.get(column);
        if (null == doubleS || 0 == doubleS.trim().length()) {
            return null;
        }
        try {
            return Double.parseDouble(doubleS);
        }
        catch (NumberFormatException nfe) {
            return this._failedToInterpretHandler.failedToInterpretNumeric(column, doubleS);
        }
    }

    @Override
    public Date getDate(int column) throws IOException {
        String dateString = this.reader.get(column);
        if (null == dateString || 0 == dateString.trim().length()) {
            return null;
        }
        try {
            return new SimpleDateFormat(this.settings.getDateFormat()).parse(dateString);
        }
        catch (ParseException pe) {
            return this._failedToInterpretHandler.failedToInterpretDate(column, dateString);
        }
    }

    @Override
    public JComponent getConfigurationPanel() {
        return new CSVSettingsPanel(this.settings);
    }

    @Override
    public void setTrimValues(boolean trimValues) {
        this._trimValues = trimValues;
    }

    @Override
    public String getImportFileTypeDescription() {
        return "CSV";
    }

    public void setSafetySwitch(boolean safetySwitch) {
        this.safetySwitch = safetySwitch;
    }
}

