package com.syntevo.openapi.deprecated.util;

import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.widgets.*;
import org.jetbrains.annotations.*;

/**
 * @author syntevo GmbH
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public final class UiUtils {

	// Constants ==============================================================

	private static final String DUMMY_PASSWORD = "         ";
	private static final boolean IS_WINDOWS = System.getProperty("os.name").contains("Windows");

	// Static =================================================================

	@NotNull
	public static Label createLabel(@NotNull String text, @NotNull Composite parent) {
		final Label label = new Label(parent, SWT.NONE);
		label.setText(text);

		return label;
	}

	@NotNull
	public static Button createCheckBox(@NotNull String text, @NotNull Composite parent) {
		final Button checkBox = new Button(parent, SWT.CHECK);
		checkBox.setText(text);

		return checkBox;
	}

	@NotNull
	public static Button createRadioButton(@NotNull String text, @NotNull Composite parent) {
		final Button radioButton = new Button(parent, SWT.RADIO);
		radioButton.setText(text);

		return radioButton;
	}

	@NotNull
	public static Text createTextField(@Nullable String defaultText, @NotNull Composite parent) {
		final Text text = new Text(parent, SWT.BORDER | SWT.SINGLE);

		if (defaultText != null) {
			text.setText(defaultText);
		}

		selectTextIfTabbingToComponent(text);
		return text;
	}

	@NotNull
	public static Text createTextArea(@Nullable String defaultText, @NotNull Composite parent) {
		final Text text = new Text(parent, SWT.BORDER | SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL);

		if (defaultText != null) {
			text.setText(defaultText);
		}

		selectTextIfTabbingToComponent(text);
		return text;
	}

	@NotNull
	public static Text createPasswordField(boolean hasKnownPassword, @NotNull Composite parent) {
		final Text text = new Text(parent, SWT.BORDER | SWT.PASSWORD);

		if (hasKnownPassword) {
			text.setText(DUMMY_PASSWORD);
		}

		selectTextIfTabbingToComponent(text);
		return text;
	}

	@Nullable
	public static String getPassword(@NotNull Text passwordField, @Nullable String knownPassword) {
		final String text = passwordField.getText();

		if (DUMMY_PASSWORD.equals(text)) {
			return knownPassword;
		}

		return text;
	}

	@NotNull
	public static Button createButton(@NotNull String text, @NotNull SelectionListener listener, @NotNull Composite parent) {
		final Button button = new Button(parent, SWT.PUSH);

		button.setText(text);
		button.addSelectionListener(listener);

		return button;
	}

	public static void setText(@NotNull Text textControl, @NotNull String text) {
		textControl.setText(text);

		if (IS_WINDOWS) {
			textControl.selectAll();
		}
	}

	public static boolean isSwtThread() {
		return Display.getCurrent() != null;
	}

	public static void assertThreadAccess() {
		if (isSwtThread()) {
			return;
		}

		throw new InternalError("SWT thread expected, current thread: " + Thread.currentThread());
	}

	// Utils ==================================================================

	private static void selectTextIfTabbingToComponent(@NotNull final Text text) {
		if (!IS_WINDOWS) {
			return;
		}

		text.selectAll();
		text.addListener(SWT.FocusOut, new Listener() {
			@Override
			public void handleEvent(Event event) {
				text.selectAll();
			}
		});
	}
}