package com.syntevo.openapi.deprecated.util;

import org.jetbrains.annotations.*;

/**
 * @author syntevo GmbH
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public final class Assert {

	// Setup ==================================================================

	private Assert() {
	}

	// Assertions =============================================================

	@NotNull
	public static <O> O assertNotNull(O obj) {
		assertTrue(obj != null, "Object must not be null!");

		return obj;
	}

	@NotNull
	public static <O> O assertNotNull(O obj, String text) {
		assertTrue(obj != null, "Object must not be null: " + text);
		return obj;
	}

	public static void assertEquals(int i1, int i2) {
		assertTrue(i1 == i2, i1 + " != " + i2);
	}

	public static void assertTrue(boolean forceTrueCondition) {
		assertTrue(forceTrueCondition, "");
	}

	public static void assertTrue(boolean forceTrueCondition, String text) {
		if (forceTrueCondition) {
			return;
		}

		throw createErrorException(text);
	}

	// Utils ==================================================================

	private static AssertException createErrorException(String message) {
		return new AssertException(message != null ? message : "");
	}
}
