/*
 * Copyright (c) 2009 by syntevo GmbH. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of syntevo GmbH nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.syntevo.openapi.deprecated.smartsvn.settings;

import java.util.*;

import org.jetbrains.annotations.*;

/**
 * Settings utility methods.
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public final class SettingsUtils {

	// Static =================================================================

	public static boolean getBooleanValue(@NotNull String key, boolean defaultValue, @NotNull Settings settings) {
		final String value = settings.getString(key, null);
		if ("true".equals(value)) {
			return true;
		}
		if ("false".equals(value)) {
			return false;
		}
		return defaultValue;
	}

	public static void setBooleanValue(@NotNull String key, boolean value, @NotNull Settings settings) {
		settings.putString(key, value ? "true" : "false");
	}

	public static int getIntegerValue(@NotNull String key, int defaultValue, @NotNull Settings settings) {
		final String value = settings.getString(key, null);
		if (value != null) {
			try {
				return Integer.parseInt(value);
			}
			catch (NumberFormatException ex) {
				// ignore
			}
		}
		return defaultValue;
	}

	public static void setIntegerValue(@NotNull String key, int value, @NotNull Settings settings) {
		settings.putString(key, String.valueOf(value));
	}

	public static long getLongValue(@NotNull String key, long defaultValue, @NotNull Settings settings) {
		final String value = settings.getString(key, null);
		if (value != null) {
			try {
				return Long.parseLong(value);
			}
			catch (NumberFormatException ex) {
				// ignore
			}
		}
		return defaultValue;
	}

	public static void setLongValue(@NotNull String key, long value, @NotNull Settings settings) {
		settings.putString(key, String.valueOf(value));
	}

	public static byte getByteValue(@NotNull String key, byte defaultValue, @NotNull Settings settings) {
		final String value = settings.getString(key, null);
		if (value != null) {
			try {
				return Byte.parseByte(value);
			}
			catch (NumberFormatException ex) {
				// ignore
			}
		}
		return defaultValue;
	}

	public static void setByteValue(@NotNull String key, byte value, @NotNull Settings settings) {
		settings.putString(key, String.valueOf(value));
	}

	public static float getFloatValue(@NotNull String key, float defaultValue, @NotNull Settings settings) {
		final String value = settings.getString(key, null);
		if (value != null) {
			try {
				return Float.parseFloat(value);
			}
			catch (NumberFormatException ex) {
				// ignore
			}
		}
		return defaultValue;
	}

	public static void setFloatValue(@NotNull String key, float value, @NotNull Settings settings) {
		settings.putString(key, String.valueOf(value));
	}

	public static double getDoubleValue(@NotNull String key, double defaultValue, @NotNull Settings settings) {
		final String value = settings.getString(key, null);
		if (value != null) {
			try {
				return Double.parseDouble(value);
			}
			catch (NumberFormatException ex) {
				// ignore
			}
		}
		return defaultValue;
	}

	public static void setDoubleValue(@NotNull String key, double value, @NotNull Settings settings) {
		settings.putString(key, String.valueOf(value));
	}

	public static char getCharValue(@NotNull String key, char defaultValue, @NotNull Settings settings) {
		final String value = settings.getString(key, null);
		return value != null && value.length() == 1 ? value.charAt(0) : defaultValue;
	}

	public static void setCharValue(@NotNull String key, char value, @NotNull Settings settings) {
		settings.putString(key, String.valueOf(value));
	}

	@NotNull
	public static List<String> getStrings(@NotNull String key, @NotNull Settings settings) {
		final int count = Math.max(0, getIntegerValue(key, 0, settings));
		final List<String> strings = new ArrayList<String>();
		for (int i = 0; i < count; i++) {
			strings.add(settings.getString(getIndexedKey(key, i), null));
		}
		return strings;
	}

	public static void setStrings(@NotNull String key, @NotNull List<String> strings, @NotNull Settings settings) {
		final int oldCount = getIntegerValue(key, 0, settings);
		setIntegerValue(key, strings.size(), settings);
		int i = 0;
		for (final Iterator<String> it = strings.iterator(); it.hasNext(); i++) {
			final String string = it.next();
			settings.putString(getIndexedKey(key, i), string);
		}
		for (; i < oldCount; i++) {
			settings.removeValue(getIndexedKey(key, i));
		}
	}

	// Setup ==================================================================

	private SettingsUtils() {
	}

	// Utils ==================================================================

	@NotNull
	private static String getIndexedKey(String key, int i) {
		return key + '.' + i;
	}
}
