package com.syntevo.openapi.deprecated.smartsvn.gui.menu;

import java.util.*;

import org.jetbrains.annotations.*;

/**
 * Contains all constants to reverence menu items in the SmartSVN project window.
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public final class ProjectActionIds {

	// Constants ==============================================================

	@NotNull
	private static final Set<String> PRIVATE_ALL_IDS = new HashSet<>();
	@NotNull
	public static final String CHANGESET_DELETE = add("changeset-delete");
	@NotNull
	public static final String CHANGESET_MOVE_DOWN = add("changeset-move-down");
	@NotNull
	public static final String CHANGESET_MOVE_TO_OTHER = add("changeset-move-to-other");
	@NotNull
	public static final String CHANGESET_MOVE_UP = add("changeset-move-up");
	@NotNull
	public static final String CHANGESET_PROPERTIES = add("changeset-properties");
	@NotNull
	public static final String EDIT_CUSTOMIZE = add("customize");
	@NotNull
	public static final String EDIT_COPY_NAME = add("copy-name");
	@NotNull
	public static final String EDIT_COPY_PATH = add("copy-path");
	@NotNull
	public static final String EDIT_COPY_PATH_AND_REVISION = add("copy-path-and-revision");
	@NotNull
	public static final String EDIT_COPY_MESSAGE = add("edit-copy-message");
	@NotNull
	public static final String EDIT_COPY_RELATIVE_PATH = add("copy-relative-path");
	@NotNull
	public static final String EDIT_COPY_URL = add("copy-url");
	@NotNull
	public static final String EDIT_COPY_REVISION_NUMBER = add("copy-revision-number");
	@NotNull
	public static final String EDIT_FILTER = add("filter-files");
	@NotNull
	public static final String OUTPUT_CLEAR = add("output-clear");
	@NotNull
	public static final String OPEN = add("open");
	@NotNull
	public static final String EDIT_PREFERENCES = add("preferences");
	@NotNull
	public static final String EDIT_SELECT_COMMITTABLE = add("select-committable");
	@NotNull
	public static final String EDIT_SELECT_DIRECTORY = add("select-directory");
	@NotNull
	public static final String EDIT_SELECT_IN_FILE_TABLE = add("edit-select-in-file-table");
	@NotNull
	public static final String EDIT_STOP = add("edit-stop");
	@NotNull
	public static final String HELP_ABOUT = add("help-about");
	@NotNull
	public static final String HELP_CHECK_FOR_NEW_VERSION = add("help-check-for-new-version");
	@NotNull
	public static final String HELP_CHECK_FOR_LATEST_BUILD = add("help-check-for-latest-build");
	@NotNull
	public static final String HELP_CONTACT_SUPPORT = add("help-contact-support");
	@NotNull
	public static final String HELP_CONTENT = add("help-content");
	@NotNull
	public static final String HELP_OBFUSCATE_LOG_CACHE = add("help-obfuscate-log-cache");
	@NotNull
	public static final String HELP_REGISTER = add("help-register");
	@NotNull
	public static final String HELP_UNREGISTER = add("help-unregister");
	@NotNull
	public static final String LICENSE_AGREEMENT = add("license-agreement");
	@NotNull
	public static final String LOCKS_REFRESH = add("locks-refresh");
	@NotNull
	public static final String LOCKS_LOCK = add("locks-lock");
	@NotNull
	public static final String LOCKS_UNLOCK = add("locks-unlock");
	@NotNull
	public static final String LOCKS_INFO = add("locks-info");
	@NotNull
	public static final String LOCKS_CHANGE_NEEDS_LOCK = add("locks-change-needs-lock");
	@NotNull
	public static final String MODIFY_ADD = add("add");
	@NotNull
	public static final String MODIFY_COMMIT = add("commit");
	@NotNull
	public static final String MODIFY_COPY = add("copy");
	@NotNull
	public static final String MODIFY_COPY_WC_URL = add("copy-wc-url");
	@NotNull
	public static final String MODIFY_COPY_URL_WC = add("copy-url-wc");
	@NotNull
	public static final String MODIFY_COPY_URL_URL = add("copy-url-url");
	@NotNull
	public static final String MODIFY_CLEANUP = add("cleanup");
	@NotNull
	public static final String MODIFY_CREATE_DIRECTORY = add("create-directory");
	@NotNull
	public static final String MODIFY_DELETE = add("delete-file");
	@NotNull
	public static final String MODIFY_IGNORE = add("ignore-file");
	@NotNull
	public static final String MODIFY_MARK_REPLACED = add("mark-replaced");
	@NotNull
	public static final String MODIFY_MERGE = add("merge");
	@NotNull
	public static final String MODIFY_MERGE_TWO_SOURCES = add("merge-two-sources");
	@NotNull
	public static final String MODIFY_MOVE = add("move");
	@NotNull
	public static final String MODIFY_PATCH_APPLY = add("apply-patch");
	@NotNull
	public static final String MODIFY_RELOCATE = add("relocate");
	@NotNull
	public static final String MODIFY_REMOVE = add("remove");
	@NotNull
	public static final String MODIFY_RENAME = add("rename");
	@NotNull
	public static final String MODIFY_REPAIR = add("repair");
	@NotNull
	public static final String MODIFY_RESOLVE = add("resolve");
	@NotNull
	public static final String MODIFY_REVERT = add("revert");
	@NotNull
	public static final String MODIFY_SMART_MOVE = add("smart-move");
	@NotNull
	public static final String MODIFY_SWITCH = add("switch");
	@NotNull
	public static final String MODIFY_UPDATE = add("update");
	@NotNull
	public static final String MODIFY_UPDATE_MORE = add("update-more");
	@NotNull
	public static final String MODIFY_UPDATE_EXCLUDE = add("update-exclude");
	@NotNull
	public static final String PROJECT_CHECKOUT = add("checkout");
	@NotNull
	public static final String PROJECT_CREATE_MODULE = add("create-module");
	@NotNull
	public static final String PROJECT_CLOSE = add("close-project");
	@NotNull
	public static final String PROJECT_DEFAULTS = add("project-defaults");
	@NotNull
	public static final String PROJECT_EDIT_WORKING_COPY = add("edit-working-copy");
	@NotNull
	public static final String PROJECT_MANAGE_AS_PROJECT = add("manage-as-project");
	@NotNull
	public static final String PROJECT_EXIT = add("exit");
	@NotNull
	public static final String PROJECT_MANAGER = add("project-manager");
	@NotNull
	public static final String PROJECT_OPEN_WORKING_COPY = add("create-project");
	@NotNull
	public static final String PROJECT_REMOVE_WORKING_COPY = add("remove-working-copy");
	@NotNull
	public static final String PROJECT_SETTINGS = add("project-settings");
	@NotNull
	public static final String PROJECT_MANAGE_LOG_CACHES = add("rebuild-log-cache");
	@NotNull
	public static final String PROJECT_REPOSITORY_SETUP = add("create-repository");
	@NotNull
	public static final String QUERY_CONFLICT_SOLVER = add("conflict-solver");
	@NotNull
	public static final String QUERY_EXPORT_BACKUP = add("export-backup");
	@NotNull
	public static final String QUERY_ANNOTATE = add("annotate");
	@NotNull
	public static final String QUERY_SHOW_CHANGES = add("compare");
	@NotNull
	public static final String QUERY_COMPARE_2_FILES = add("compare-two-files");
	@NotNull
	public static final String QUERY_COMPARE_TWO_URLS = add("compare-two-urls");
	@NotNull
	public static final String QUERY_COMPARE_WITH_HEAD = add("compare-with-head");
	@NotNull
	public static final String QUERY_COMPARE_WITH_PREVIOUS = add("compare-with-previous");
	@NotNull
	public static final String QUERY_COMPARE_WITH_REVISION = add("compare-with-revision");
	@NotNull
	public static final String QUERY_DIFF_LOCAL = add("diff-local");
	@NotNull
	public static final String QUERY_REPOSITORY_BROWSE = add("repository-open-entry");
	@NotNull
	public static final String QUERY_DIFF_URLS = add("diff-urls");
	@NotNull
	public static final String QUERY_LOG = add("log");
	@NotNull
	public static final String QUERY_REVISION_GRAPH = add("revision-graph");
	@NotNull
	public static final String QUERY_REMOTE_STATE_CLEAR = add("remote-state-clear");
	@NotNull
	public static final String QUERY_REMOTE_STATE_REFRESH = add("remote-state-refresh");
	@NotNull
	public static final String PROPERTIES_BUGTRAQ_EDIT = add("properties-bugtraq-edit");
	@NotNull
	public static final String PROPERTIES_CHANGE_MIME_TYPE = add("properties-change-mime-type");
	@NotNull
	public static final String PROPERTIES_EDIT = add("properties-edit");
	@NotNull
	public static final String PROPERTIES_EOL_STYLE = add("properties-eol-style");
	@NotNull
	public static final String PROPERTIES_EXECUTABLE_PROPERTY = add("properties-executable-property");
	@NotNull
	public static final String PROPERTIES_EXTERNALS_EDIT = add("properties-externals-edit");
	@NotNull
	public static final String PROPERTIES_IGNORE_EDIT = add("properties-ignore-edit");
	@NotNull
	public static final String PROPERTIES_KEYWORD_SUBSTITUTION = add("properties-keyword-substitution");
	@NotNull
	public static final String PROPERTIES_MERGEINFO_EDIT = add("properties-mergeinfo-edit");
	@NotNull
	public static final String PROPERTIES_SET = add("properties-set");
	@NotNull
	public static final String TAG_ADD_TAG = add("tag-add-tag");
	@NotNull
	public static final String TAG_ADD_BRANCH = add("tag-add-branch");
	@NotNull
	public static final String TAG_BROWSER = add("tag-browser");
	@NotNull
	public static final String TAG_LAYOUT_CONFIGURE = add("tag-layout-configure");
	@NotNull
	public static final String VIEW_ASSIGNED_TO_CHANGESET = add("view-assigned-to-changeset");
	@NotNull
	public static final String VIEW_IGNORED = add("view-ignored");
	@NotNull
	public static final String VIEW_RECURSIVE = add("view-recursive");
	@NotNull
	public static final String VIEW_REFRESH = add("refresh");
	@NotNull
	public static final String VIEW_REMOTE_CHANGED = add("view-remote-changed");
	@NotNull
	public static final String VIEW_TABLE_COLUMNS = add("view-table-columns");
	@NotNull
	public static final String VIEW_UNCHANGED = add("view-unchanged");
	@NotNull
	public static final String VIEW_UNVERSIONED = add("view-unversioned");
	@NotNull
	public static final String WINDOW_NEW_PROJECT_WINDOW = add("window-new");
	@NotNull
	public static final String WINDOW_NEW_REPOSITORY_BROWSER = add("window-repository-browser");
	@NotNull
	public static final String WINDOW_HIDE_VIEW = add("windows-hide-view");
	@NotNull
	public static final String WINDOW_MAXIMIZE_RESTORE = add("windows-maximize-restore");
	@NotNull
	public static final String WINDOW_PERSPECTIVE_RESET = add("windows-reset-perspective");
	@NotNull
	public static final String WINDOW_PERSPECTIVE_SET_MAIN = add("windows-perspective-set-main");
	@NotNull
	public static final String WINDOW_PERSPECTIVE_SET_REVIEW = add("windows-perspective-set-review");
	@NotNull
	public static final String WINDOW_SHOW_TRANSACTIONS_WINDOW = add("window-show-transaction-window");
	@NotNull
	public static final String WINDOW_CHANGES_ACTIVATE = add("windows-changes-activate");
	@NotNull
	public static final String WINDOW_CHANGES_IGNORE_CASE_CHANGES = add("window-changes-ignore-case-changes");
	@NotNull
	public static final String WINDOW_CHANGES_IGNORE_WHITESPACES = add("window-changes-ignore-whitespaces");
	@NotNull
	public static final String WINDOW_CHANGES_NEXT = add("window-changes-next");
	@NotNull
	public static final String WINDOW_CHANGES_PREVIOUS = add("window-changes-previous");
	@NotNull
	public static final String WINDOW_CHANGES_REFRESH = add("window-changes-refresh");
	@NotNull
	public static final String WINDOW_CHANGES_SETTINGS = add("window-changes-settings");
	@NotNull
	public static final String WINDOW_DIRECTORIES_ACTIVATE = add("windows-directories-activate");
	@NotNull
	public static final String WINDOW_FILES_ACTIVATE = add("windows-files-activate");
	@NotNull
	public static final String WINDOW_OUTPUT_ACTIVATE = add("windows-output-activate");
	@NotNull
	public static final String WINDOW_TRANSACTION_ACTIVATE = add("windows-transactions-activate");
	@NotNull
	public static final String WINDOW_TRANSACTION_CONFIGURE_WATCHED_URLS = add("windows-transaction-configure");
	@NotNull
	public static final String WINDOW_TRANSACTION_MARK_ALL_AS_KNOWN = add("windows-transaction-mark-all-as-known");
	@NotNull
	public static final String WINDOW_TRANSACTION_MARK_AS_KNOWN = add("windows-transaction-mark-as-known");
	@NotNull
	public static final String WINDOW_TRANSACTION_MERGE = add("windows-transaction-merge");
	@NotNull
	public static final String WINDOW_TRANSACTION_REFRESH = add("windows-transaction-refresh");
	@NotNull
	public static final String WINDOW_TRANSACTION_ROLLBACK = add("windows-transaction-rollback");
	@NotNull
	public static final String WINDOW_TRANSACTION_SET_COMMIT_MESSAGE = add("windows-transaction-set-commit-message");
	@NotNull
	public static final String WINDOW_TRANSACTION_UPDATE = add("windows-transaction-update");
	@NotNull
	public static final String WINDOW_TRANSACTION_VIEW_ADDITIONAL_LOCATIONS = add("windows-transaction-show-additional-locations");
	@NotNull
	public static final String WINDOW_TRANSACTION_VIEW_BRANCHES_TAGS = add("windows-transaction-show-tags");
	@NotNull
	public static final String WINDOW_TRANSACTION_VIEW_SETTINGS = add("windows-transaction-settings");
	@NotNull
	public static final Set<String> ALL_IDS = Collections.unmodifiableSet(PRIVATE_ALL_IDS);

	private static String add(String id) {
		if (!PRIVATE_ALL_IDS.add(id)) {
			throw new RuntimeException("id " + id + " already defined");
		}
		return id;
	}
}
