package com.syntevo.openapi.deprecated.smartsvn.gui.menu;

import java.util.*;

import org.jetbrains.annotations.*;

/**
 * Allows to get menu actions or menu structures, create menus or remove items.
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public interface MenuContainer {

	/**
	 * Returns the number of contained items.
	 */
	int getItemCount();

	/**
	 * Returns the MenuItems (MenuAction or MenuStructure) in their corresponding order.
	 */
	@NotNull
	List<? extends MenuItem> getItems();

	/**
	 * Removes the item at the specified index.
	 */
	void removeItem(int index);

	/**
	 * Create a menu or sub-menu.
	 *
	 * @param index the index within this container to add the menu at
	 * @param name the name of the sub-menu.
	 */
	@NotNull
	MenuStructure createMenu(int index, @NotNull String name);
}
