/*
 * Copyright (c) 2009 by syntevo GmbH. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of syntevo GmbH nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.syntevo.openapi.deprecated.smartsvn.file;

import org.jetbrains.annotations.*;

/**
 * Possible SVN-states for {@link SvnFile} objects.
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public final class SvnFileLocalState {

	// Constants ==============================================================

	@NotNull
	public static final SvnFileLocalState ADDED = new SvnFileLocalState("added");
	@NotNull
	public static final SvnFileLocalState CASE_CHANGED = new SvnFileLocalState("case-changed");
	@NotNull
	public static final SvnFileLocalState CONFLICT = new SvnFileLocalState("conflict");
	@NotNull
	public static final SvnFileLocalState COPIED = new SvnFileLocalState("copied");
	@NotNull
	public static final SvnFileLocalState HISTORY_SCHEDULED = new SvnFileLocalState("history scheduled");
	@NotNull
	public static final SvnFileLocalState HISTORY_SCHEDULED_MODIFIED = new SvnFileLocalState("history scheduled modified");
	@NotNull
	public static final SvnFileLocalState IGNORED = new SvnFileLocalState("ignored");
	@NotNull
	public static final SvnFileLocalState INACCESSIBLE = new SvnFileLocalState("inaccessible");
	@NotNull
	public static final SvnFileLocalState MERGED = new SvnFileLocalState("merged");
	@NotNull
	public static final SvnFileLocalState MISSING = new SvnFileLocalState("missing");
	@NotNull
	public static final SvnFileLocalState MODIFIED = new SvnFileLocalState("modified");
	@NotNull
	public static final SvnFileLocalState MOVED = new SvnFileLocalState("moved");
	@NotNull
	public static final SvnFileLocalState OBSTRUCTED = new SvnFileLocalState("obstructed");
	@NotNull
	public static final SvnFileLocalState PHANTOM = new SvnFileLocalState("phantom");
	@NotNull
	public static final SvnFileLocalState REMOTE = new SvnFileLocalState("repository-only");
	@NotNull
	public static final SvnFileLocalState REMOVED = new SvnFileLocalState("removed");
	@NotNull
	public static final SvnFileLocalState REPLACED = new SvnFileLocalState("replaced");
	@NotNull
	public static final SvnFileLocalState UNCHANGED = new SvnFileLocalState("unchanged");
	@NotNull
	public static final SvnFileLocalState UNKNOWN = new SvnFileLocalState("?????");
	@NotNull
	public static final SvnFileLocalState UNVERSIONED = new SvnFileLocalState("unversioned");

	// Fields =================================================================

	private final String name;

	// Setup ==================================================================

	private SvnFileLocalState(@NotNull String name) {
		this.name = name;
	}

	// Implemented ============================================================

	@NotNull
	public String toString() {
		return name;
	}
}
