/*
 * Copyright (c) 2009 by syntevo GmbH. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of syntevo GmbH nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.syntevo.openapi.deprecated.smartsvn.file;

import org.jetbrains.annotations.*;

/**
 * Possible SVN-states for {@link SvnDirectory} objects.
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public final class SvnDirectoryLocalState {

	// Constants ==============================================================

	@NotNull
	public static final SvnDirectoryLocalState ADDED = new SvnDirectoryLocalState("added");
	@NotNull
	public static final SvnDirectoryLocalState ADDED_MISSING = new SvnDirectoryLocalState("added-missing");
	@NotNull
	public static final SvnDirectoryLocalState AUXILIARY = new SvnDirectoryLocalState("auxiliary");
	@NotNull
	public static final SvnDirectoryLocalState CONFLICT = new SvnDirectoryLocalState("conflict");
	@NotNull
	public static final SvnDirectoryLocalState COPIED = new SvnDirectoryLocalState("copied");
	@NotNull
	public static final SvnDirectoryLocalState HISTORY_SCHEDULED = new SvnDirectoryLocalState("historyScheduled");
	@NotNull
	public static final SvnDirectoryLocalState HISTORY_SCHEDULED_MODIFIED = new SvnDirectoryLocalState("historyScheduledModified");
	@NotNull
	public static final SvnDirectoryLocalState IGNORED = new SvnDirectoryLocalState("ignored");
	@NotNull
	public static final SvnDirectoryLocalState INCOMPLETE = new SvnDirectoryLocalState("incomplete");
	@NotNull
	public static final SvnDirectoryLocalState OBSTRUCTED = new SvnDirectoryLocalState("obstructed");
	@NotNull
	public static final SvnDirectoryLocalState MISSING = new SvnDirectoryLocalState("missing");
	@NotNull
	public static final SvnDirectoryLocalState MODIFIED = new SvnDirectoryLocalState("modified");
	@NotNull
	public static final SvnDirectoryLocalState MOVED = new SvnDirectoryLocalState("moved");
	@NotNull
	public static final SvnDirectoryLocalState NESTED_ROOT = new SvnDirectoryLocalState("nested-root");
	@NotNull
	public static final SvnDirectoryLocalState PHANTOM = new SvnDirectoryLocalState("phantom");
	@NotNull
	public static final SvnDirectoryLocalState REMOTE = new SvnDirectoryLocalState("remote");
	@NotNull
	public static final SvnDirectoryLocalState REMOVED = new SvnDirectoryLocalState("removed");
	@NotNull
	public static final SvnDirectoryLocalState REPLACED = new SvnDirectoryLocalState("replaced");
	@NotNull
	public static final SvnDirectoryLocalState UNCHANGED = new SvnDirectoryLocalState("unchanged");
	@NotNull
	public static final SvnDirectoryLocalState UNVERSIONED = new SvnDirectoryLocalState("unversioned");

	// Fields =================================================================

	private final String name;

	// Setup ==================================================================

	private SvnDirectoryLocalState(@NotNull String name) {
		this.name = name;
	}

	// Implemented ============================================================

	public String toString() {
		return name;
	}
}
