/*
 * Copyright (c) 2009 syntevo GmbH. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of syntevo GmbH nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.syntevo.openapi.deprecated.smartsvn.command;

import org.apache.subversion.javahl.*;
import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.smartsvn.thread.*;

/**
 * An ISvnCommand contains code performing SVN operations or other
 * file system operations.
 *
 * ISvnCommands are reusing the infrastructure of SmartSVN: The SvnClients
 * can be used to create pre-configured ISVN*Clients: ISVNOptions,
 * ISVNAuthenticationManager, etc. are already set based on Project
 * Settings and Repository Profiles of SmartSVN. The clients also have set
 * an ISVNEventHandler which outputs the affected files/directories to
 * SmartSVN's Output area.
 *
 * ISvnCommands are performed in a special background thread which locks
 * the Project Window.
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public interface ISvnCommand {

	/**
	 * Perform the SVN operations and/or other file system operations.
	 *
	 * @param svnClients preconfigured SVN*Client factory
	 * @param progressViewer for displaying command progress
	 * @throws SubversionException in case of SVN errors
	 */
	void perform(@NotNull SvnClients svnClients, @NotNull ProgressViewer progressViewer) throws SubversionException;
}
