/*
 * Copyright (c) 2009 by syntevo GmbH. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of syntevo GmbH nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.syntevo.openapi.deprecated.smartsvn.action;

import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.smartsvn.gui.menu.*;

/**
 * An IActionProvider can be used to add custom actions to SmartSVN's project window.
 * Actions are identified by IDs. Adding a custom action consists of two phases:
 * <p/>
 * First the menu item location has to be defined in the {@link #modifyMenuBar(MenuContainer)} method
 * as well as its text, tooltip and further flags.
 * <p/>
 * Second, the actual Action instances are created and registered in the {@link #createActions(ActionRegisterService)} method.
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public interface IActionProvider {

	/**
	 * Use this method to defined the location of new menu items in the specified <code>menuContainer</code>
	 * or to remove unneeded menu items.
	 * With the passed <code>menuContainer</code> you have access to the existing menus, menu items or submenus.
	 *
	 * @param menuContainer represents the menu bar
	 * @see MenuStructure
	 * @see MenuUtils
	 */
	void modifyMenuBar(@NotNull MenuContainer menuContainer);

	/**
	 * Create action instances and register via the specified ActionRegisterService.
	 * This method is invoked for each new opened project window.
	 *
	 * @param service to add register action instances
	 */
	void createActions(@NotNull ActionRegisterService service);
}
