/*
 * Copyright (c) 2009 by syntevo GmbH. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of syntevo GmbH nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.syntevo.openapi.deprecated.gui.table;

import org.eclipse.swt.graphics.*;
import org.jetbrains.annotations.*;

/**
 * A column of a table. See SortedTable for details.
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public interface ITableColumn<RO> {

	/**
	 * Returns the name of the column which will be displayed in the table header.
	 */
	@NotNull
	String getColumnName();

	/**
	 * Returns whether the content should be displayed right-aligned.
	 */
	boolean isRightAligned();

	/**
	 * Returns the column's textual representation for the specified row object.
	 *
	 * @return the column's text for the row object
	 */
	@Nullable
	String getText(@NotNull RO rowObject);

	/**
	 * Returns the column's image for the specified row object.
	 *
	 * @return the column's text for the row object
	 */
	@Nullable
	Image getImage(@NotNull RO rowObject);

	/**
	 * Compare the specified row objects from this columns perspective.
	 *
	 * @return -1 if rowObject1 is less than rowObject2, 0 if both objects are equal or +1 if rowObject1 is greated than rowObject2
	 */
	int compare(@NotNull RO rowObject1, @NotNull RO rowObject2);
}
