/*
 * Copyright (c) 2009 by syntevo GmbH. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of syntevo GmbH nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.syntevo.openapi.deprecated;

import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.smartsvn.*;

/**
 * Each plugin needs to implement this class.
 * The class name of the plugin's implementation of IActivator needs to be defined in the plugin.properties file with the key activatorClass.
 * The IActivator implementation needs to have a public constructor with no arguments, because its instance will be created dynamically.
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public interface IActivator {

	/**
	 * This version represents the current version of the API.
	 * <br/>
	 * Changes in 7.7:
	 * <ul>
	 *     <li>made independent of JFace, e.g. replacing KeyStroke with int (modifier | key)</li>
	 * </ul>
	 */
	@NotNull
	String VERSION = "7.7";

	/**
	 * This version represents the minimum API version to which the current API version is compatible to.
	 * In other words, SmartSVN can load all plugins which define a version between the #BACKWARD_COMPATIBLE_TO_VERSION and #VERSION.
	 */
	@NotNull
	String BACKWARD_COMPATIBLE_TO_VERSION = "7.7";

	/**
	 * Called by SmartSVN in the startup phase. Use SmartSvnServices to register the plugin
	 * is various ways.
	 * @param services to set
	 */
	void initialize(@NotNull SmartSvnServices services);
}
