#!/bin/bash
#
# Editing this script should not be required.
#
# To specify an alternative Java Runtime Environment, set the environment
#
# jre=/path/to/jre
#
# line to smartsvn.vmoptions (see below).
#
# To specify additional VM options, add them to smartsvn.vmoptions
# or ~/.smartsvn/smartsvn.vmoptions files.

parseVmOptions() {
  if [ -f $1 ]; then
    while read LINE || [[ -n "$LINE" ]]; do
      LINE="${LINE#"${LINE%%[![:space:]]*}"}"
      if [ ${#LINE} -gt 0 ] && [ ! ${LINE:0:1} == '#' ]; then
        if [ ${LINE:0:4} == 'jre=' ]; then
          SMARTSVN_JAVA_HOME="${LINE:4}"
        else
          _VM_PROPERTIES="$_VM_PROPERTIES $LINE"
        fi
      fi
    done < $1
  fi
}

echoJreConfigurationAndExit() {
  echo "Add the line"
  echo "jre=/path/to/jre"
  echo "to ~/.smartsvn/smartsvn.vmoptions and change the path"
  echo "to the one pointing to the desired JRE."
  exit 1
}

case "$BASH" in
    */bash) :
        ;;
    *)
        exec /bin/bash "$0" "$@"
        ;;
esac

# Resolve the location of the SmartSVN installation.
# This includes resolving any symlinks.
PRG=$0
while [ -h "$PRG" ]; do
  ls=`ls -ld "$PRG"`
  link=`expr "$ls" : '^.*-> \(.*\)$' 2>/dev/null`
  if expr "$link" : '^/' 2> /dev/null >/dev/null; then
    PRG="$link"
  else
    PRG="`dirname "$PRG"`/$link"
  fi
done

SMARTSVN_BIN=`dirname "$PRG"`

# Absolutize dir
oldpwd=`pwd`
cd "${SMARTSVN_BIN}";
SMARTSVN_BIN=`pwd`
cd "${oldpwd}";
unset oldpwd

SMARTSVN_HOME=`dirname "$SMARTSVN_BIN"`

parseVmOptions $SMARTSVN_BIN/smartsvn.vmoptions
parseVmOptions ~/.smartsvn/smartsvn.vmoptions

# Determine Java Runtime
if [ "$SMARTSVN_JAVA_HOME" = "" ] ; then
	SMARTSVN_JAVA_HOME=$SMARTSVNHG_JAVA_HOME
fi
if [ "$SMARTSVN_JAVA_HOME" = "" ] && [ -f "/usr/lib/jvm/java-7-openjdk-i386/jre/bin/java" ] ; then
	SMARTSVN_JAVA_HOME="/usr/lib/jvm/java-7-openjdk-i386/jre"
fi
if [ "$SMARTSVN_JAVA_HOME" = "" ] ; then
	SMARTSVN_JAVA_HOME=$JAVA_HOME
fi

_JAVA_EXEC="java"
if [ "$SMARTSVN_JAVA_HOME" != "" ] ; then
    _TMP="$SMARTSVN_JAVA_HOME/bin/java"
    if [ -f "$_TMP" ] ; then
        if [ -x "$_TMP" ] ; then
            _JAVA_EXEC="$_TMP"
        else
            echo "Warning: $_TMP is not executable"
        fi
    else
        echo "Warning: $_TMP does not exist"
    fi
fi

if ! which "$_JAVA_EXEC" >/dev/null 2>&1 ; then
    echo "Error: No java environment found (JRE 1.7 or higher required)."
    echoJreConfigurationAndExit
fi

# check that the environment is 1.7 or higher
JAVA_VERSION=$($_JAVA_EXEC -version 2>&1 | awk -F '"' '/version/ {print $2}')
if [[ "$JAVA_VERSION" < "1.7" ]]; then
    echo "Java version 1.7 or higher is required, currently $JAVA_EXEC is used (version $JAVA_VERSION)"
    echoJreConfigurationAndExit
fi

# this seems necessary for Solaris to find the Cairo-library
export LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:/usr/lib/gnome-private/lib

# Without the following line sliders are not visible in Ubuntu 12.04
# (see <https://bugs.eclipse.org/bugs/show_bug.cgi?id=368929>)
export LIBOVERLAY_SCROLLBAR=0

# work-around for SWT bug https://bugs.eclipse.org/bugs/show_bug.cgi?id=419729
if type "lsb_release" > /dev/null 2> /dev/null ; then
    UBUNTU_VERSION=`lsb_release -a 2>/dev/null | grep Release | cut -d ':' -f2 | tr -d '\t' | tr -d ' '`

    if [ "$UBUNTU_VERSION" == "13.10" ] || [ "$UBUNTU_VERSION" == "14.04" ] || [ "$UBUNTU_VERSION" == "14.10" ] ; then
        export UBUNTU_MENUPROXY=0
    fi
fi

# as workaround for https://bugs.eclipse.org/bugs/show_bug.cgi?id=435773
export SWT_GTK3=0

_GC_OPTS="-XX:+UseG1GC -XX:MaxGCPauseMillis=100 -XX:InitiatingHeapOccupancyPercent=25 -Xmx768m"
_MISC_OPTS="-Xverify:none -Dsun.io.useCanonCaches=false"

# detect SmartSVN environment
_SMARTSVN_ENVIRONMENT="$($_JAVA_EXEC $_GC_OPTS $_MISC_OPTS $_VM_PROPERTIES -jar "$SMARTSVN_HOME/lib/bootloader.jar" -dump-environment)"
_SUBVERSION_LIBRARY_PATH=$(echo "$_SMARTSVN_ENVIRONMENT" | grep subversion.binary.path | cut -d: -f2-)
_USER_PREFERENCES_PATH=$(echo "$_SMARTSVN_ENVIRONMENT" | grep user.preferences.path | cut -d: -f2-)
_SYSTEM_JRE_PATH=$(echo "$_SMARTSVN_ENVIRONMENT" | grep java.home | cut -d: -f2-)

# fatal JVM error log file
_JVM_ERROR_LOG_FILE="$_USER_PREFERENCES_PATH/../smartsvn_jvm_error_%p.log"

# pickup proper SASL2 libraries
export SASL_PATH="$_SUBVERSION_LIBRARY_PATH/sasl2"

# setup dynamic loader path to pickup proper subversion client libraries
export LD_LIBRARY_PATH=${_SUBVERSION_LIBRARY_PATH}:${LD_LIBRARY_PATH}

# prepare clean JRE extension directory
_USER_JRE_EXT_PATH="$_USER_PREFERENCES_PATH/jre-ext/$JAVA_VERSION"
_JRE_EXT_PATH="$_SYSTEM_JRE_PATH/lib/ext"
mkdir -p "$_USER_JRE_EXT_PATH"
for extension in dnsns.jar localedata.jar sunec.jar sunjce_provider.jar sunpkcs11.jar zipfs.jar ; do
	if [ -e "$_JRE_EXT_PATH/$extension" ]; then
		ln -sf "$_JRE_EXT_PATH/$extension" "$_USER_JRE_EXT_PATH/$extension"
	fi
done
_VM_PROPERTIES="${_VM_PROPERTIES} -XX:ErrorFile=$_JVM_ERROR_LOG_FILE -Djava.ext.dirs=$_USER_JRE_EXT_PATH"

$_JAVA_EXEC $_GC_OPTS $_MISC_OPTS $_VM_PROPERTIES -jar "$SMARTSVN_HOME/lib/bootloader.jar" "$@"

