package com.syntevo.plugin.trac.transport;

import java.util.*;

import org.jetbrains.annotations.*;

/**
 * @author syntevo GmbH
 */
public class TracIssueMilestone {
	// Fields =================================================================

	private final String name;
	private final String description;
	private final Date dueDate;
	private final Date completedDate;

	// Setup ==================================================================

	public TracIssueMilestone(@NotNull String name, @Nullable String description, @Nullable Date dueDate, @Nullable Date completedDate) {
		this.name = name;
		this.description = description;
		this.dueDate = dueDate;
		this.completedDate = completedDate;
	}

	// Implemented ============================================================

	@Override
	public String toString() {
		return name;
	}

	@Override
	public int hashCode() {
		return name.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null || obj.getClass() != getClass()) {
			return false;
		}

		final TracIssueMilestone milestone = (TracIssueMilestone)obj;
		return name.equals(milestone.name);
	}

	// Accessing ==============================================================

	@NotNull
	public String getName() {
		return name;
	}

	@Nullable
	public String getDescription() {
		return description;
	}

	@Nullable
	public Date getDueDate() {
		return dueDate;
	}

	@Nullable
	public Date getCompletedDate() {
		return completedDate;
	}
}