package com.syntevo.plugin.trac.transport;

import java.util.*;

import org.jetbrains.annotations.*;

/**
 * @author syntevo GmbH
 */
public final class TracIssue {

	// Constants ==============================================================

	public static final String FIELD_ID = "id";
	public static final String FIELD_STATUS = "status";
	public static final String FIELD_CREATEDTIME = "time";
	public static final String FIELD_CHANGETIME = "changetime";
	public static final String FIELD_DESCRIPTION = "description";
	public static final String FIELD_REPORTER = "reporter";
	public static final String FIELD_CC = "cc";
	public static final String FIELD_RESOLUTION = "resolution";
	public static final String FIELD_COMPONENT = "component";
	public static final String FIELD_SUMMARY = "summary";
	public static final String FIELD_PRIORITY = "priority";
	public static final String FIELD_KEYWORDS = "keywords";
	public static final String FIELD_VERSION = "version";
	public static final String FIELD_MILESTONE = "milestone";
	public static final String FIELD_OWNER = "owner";
	public static final String FIELD_TYPE = "type";

	// Fields =================================================================

	private final long id;
	private Date createdTime;
	private TracIssueStatus status = TracIssueStatus.UNKNOWN;
	private Date changeTime;
	private String description;
	private String reporter;
	private String cc;
	private String resolution;
	private String component;
	private String summary;
	private String priority;
	private String keywords;
	private String versionName;
	private String milestoneName;
	private String owner;
	private String type;

	// Setup ==================================================================

	public TracIssue(long id) {
		this.id = id;
	}

	// Accessing ==============================================================

	public long getId() {
		return id;
	}

	@Nullable
	public Date getCreatedTime() {
		return createdTime;
	}

	public void setCreatedTime(@Nullable Date createdTime) {
		this.createdTime = createdTime;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}

		final TracIssue issue = (TracIssue)o;

		return id == issue.id;
	}

	@Override
	public int hashCode() {
		return (int)(id ^ (id >>> 32));
	}

	@NotNull
	public TracIssueStatus getStatus() {
		return status;
	}

	public void setStatus(@NotNull TracIssueStatus status) {
		this.status = status;
	}

	@Nullable
	public Date getChangeTime() {
		return changeTime;
	}

	public void setChangeTime(@Nullable Date changeTime) {
		this.changeTime = changeTime;
	}

	@Nullable
	public String getDescription() {
		return description;
	}

	public void setDescription(@Nullable String description) {
		this.description = description;
	}

	@Nullable
	public String getReporter() {
		return reporter;
	}

	public void setReporter(@Nullable String reporter) {
		this.reporter = reporter;
	}

	@Nullable
	public String getCc() {
		return cc;
	}

	public void setCc(@Nullable String cc) {
		this.cc = cc;
	}

	@Nullable
	public String getResolution() {
		return resolution;
	}

	public void setResolution(@Nullable String resolution) {
		this.resolution = resolution;
	}

	@Nullable
	public String getComponent() {
		return component;
	}

	public void setComponent(@Nullable String component) {
		this.component = component;
	}

	@Nullable
	public String getSummary() {
		return summary;
	}

	public void setSummary(@Nullable String summary) {
		this.summary = summary;
	}

	@Nullable
	public String getPriority() {
		return priority;
	}

	public void setPriority(@Nullable String priority) {
		this.priority = priority;
	}

	@Nullable
	public String getKeywords() {
		return keywords;
	}

	public void setKeywords(@Nullable String keywords) {
		this.keywords = keywords;
	}

	@Nullable
	public String getVersionName() {
		return versionName;
	}

	public void setVersionName(@Nullable String versionName) {
		this.versionName = versionName;
	}

	@Nullable
	public String getMilestoneName() {
		return milestoneName;
	}

	public void setMilestoneName(@Nullable String milestoneName) {
		this.milestoneName = milestoneName;
	}

	@Nullable
	public String getOwner() {
		return owner;
	}

	public void setOwner(@Nullable String owner) {
		this.owner = owner;
	}

	@Nullable
	public String getType() {
		return type;
	}

	public void setType(@Nullable String type) {
		this.type = type;
	}
}