package com.syntevo.plugin.trac.transport;

import java.io.*;
import java.net.*;
import javax.net.ssl.*;
import sun.misc.*;

import org.jetbrains.annotations.*;

import com.syntevo.plugin.common.bugtracker.transport.*;

/**
 * @author syntevo GmbH
 */
class TracClient extends BugtrackerClient {

	// Fields =================================================================

	private static final String PROPERTY_AUTHORIZATION = "Authorization";
	private static final String PROPERTY_CONTENT_TYPE = "Content-Type";
	private static final String CONTENT_TYPE_JSON = "application/json";
	private static final String PREFIX_BASIC_AUTH = "Basic ";

	// Setup ==================================================================

	TracClient(@NotNull BugtrackerConnection bugtrackerConnection) {
		super(bugtrackerConnection);
	}

	@Override
	public void configureConnection(@NotNull URLConnection urlConnection) throws IOException {
		if (urlConnection instanceof HttpsURLConnection) {
			final SSLContext context = createSSLContext(getBugtrackerConnection());
			((HttpsURLConnection)urlConnection).setHostnameVerifier(new BugtrackerHttpsHostnameVerifier());
			((HttpsURLConnection)urlConnection).setSSLSocketFactory(context.getSocketFactory());
		}

		final String tracUser = getBugtrackerConnection().getUsername();
		String tracAuth;

		if (tracUser != null && !tracUser.isEmpty()) {
			final String tracUserPass = getBugtrackerConnection().getPassword();
			tracAuth = tracUser;

			if (tracUserPass != null && !tracUserPass.isEmpty()) {
				tracAuth = tracAuth + ":" + tracUserPass;
			}

			final String encoding = new BASE64Encoder().encode(tracAuth.getBytes());
			urlConnection.setRequestProperty(PROPERTY_AUTHORIZATION, PREFIX_BASIC_AUTH + encoding);
		}

		urlConnection.setRequestProperty(PROPERTY_CONTENT_TYPE, CONTENT_TYPE_JSON);
		urlConnection.setDoOutput(true);
		urlConnection.setDoInput(true);
	}
}