package com.syntevo.plugin.trac.transport;

import org.jetbrains.annotations.*;

/**
 * @author syntevo GmbH
 */
public class JsonRpcException extends Exception {

	private final String errorName;
	private final Long errorCode;

	public JsonRpcException(@NotNull String errorMessage, @NotNull String errorName, @NotNull Long errorCode) {
		super(errorMessage);

		this.errorName = errorName;
		this.errorCode = errorCode;
	}

	@NotNull
	public String getErrorName() {
		return errorName;
	}

	@NotNull
	public Long getErrorCode() {
		return errorCode;
	}
}

