package com.syntevo.plugin.trac.commit.workflow;

import java.util.*;

import org.jetbrains.annotations.*;

import com.syntevo.plugin.trac.commit.*;
import com.syntevo.plugin.trac.transport.*;

/**
 * @author syntevo GmbH
 */
class TracResolvablePacket {

	// Fields =================================================================

	private final Integer issueId;
	private final TracUIConnection connection;

	private TracIssue issue;
	private List<TracIssueVersion> unreleasedVersions = new LinkedList<>();
	private List<TracIssueMilestone> incompleteMilestones = new LinkedList<>();

	// Setup ==================================================================

	public TracResolvablePacket(@NotNull Integer issueId, @NotNull TracUIConnection connection) {
		this.issueId = issueId;
		this.connection = connection;
	}

	// Implemented ============================================================

	@Override
	public String toString() {
		return issueId.toString();
	}

	@Override
	public int hashCode() {
		return issueId.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null || getClass() != obj.getClass()) {
			return false;
		}

		final TracResolvablePacket packet = (TracResolvablePacket)obj;
		return issueId.equals(packet.issueId) && connection.getUrl().equals(packet.connection.getUrl());
	}

	// Accessing ==============================================================

	@NotNull
	public Integer getIssueId() {
		return issueId;
	}

	@NotNull
	public TracUIConnection getConnection() {
		return connection;
	}

	@NotNull
	public TracIssue getIssue() {
		return issue;
	}

	public void setIssue(@NotNull TracIssue issue) {
		this.issue = issue;
	}

	@NotNull
	public List<TracIssueVersion> getUnreleasedVersions() {
		return unreleasedVersions;
	}

	public void setUnreleasedVersions(@NotNull List<TracIssueVersion> unreleasedVersions) {
		this.unreleasedVersions = new ArrayList<>(unreleasedVersions);
	}

	@NotNull
	public List<TracIssueMilestone> getIncompleteMilestones() {
		return incompleteMilestones;
	}

	public void setIncompleteMilestones(@NotNull List<TracIssueMilestone> incompleteMilestones) {
		this.incompleteMilestones = new ArrayList<>(incompleteMilestones);
	}
}