package com.syntevo.plugin.trac.commit.workflow;

import java.util.*;

import org.apache.subversion.javahl.*;
import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.gui.dialog.*;
import com.syntevo.openapi.deprecated.smartsvn.command.*;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.*;
import com.syntevo.openapi.deprecated.smartsvn.file.*;
import com.syntevo.plugin.common.bugtracker.transport.*;
import com.syntevo.plugin.trac.*;
import com.syntevo.plugin.trac.transport.*;

/**
 * @author syntevo GmbH
 */
final class TracPostCommandPhase extends FilterPostCommandPhase {

	// Fields =================================================================

	private final List<TracResolvePacket> resolvePackets;
	private final DialogDisplayer dialogDisplayer;

	// Setup ==================================================================

	public TracPostCommandPhase(@NotNull ICommitPostCommandPhase wrappedPhase, @NotNull List<TracResolvePacket> resolvePackets, @NotNull DialogDisplayer dialogDisplayer) {
		super(wrappedPhase);

		this.resolvePackets = resolvePackets;
		this.dialogDisplayer = dialogDisplayer;
	}

	// Implemented ============================================================

	@Override
	public void process(@NotNull Map<Path, ClientNotifyInformation> pathToClientNotifyInformation, @NotNull SvnClients svnClients) throws SubversionException {
		super.process(pathToClientNotifyInformation, svnClients);

		TracPlugin.LOGGER.debug("Resolving packets");

		for (TracResolvePacket resolvePacket : resolvePackets) {
			TracPlugin.LOGGER.info("Resolving " + resolvePacket);

			final BugtrackerConnection connection = resolvePacket.getConnection();
			final Integer issueId = resolvePacket.getIssueId();
			final TracJsonRpcClient queryClient = new TracJsonRpcClient(connection);

			try {
				queryClient.resolveIssue(issueId, connection.getUsername(), TracIssueResolution.FIXED, resolvePacket.getFixVersion(), resolvePacket.getFixMilestone());
				TracPlugin.LOGGER.warn(" ... resolved");
			}
			catch (Exception ex) {
				TracPlugin.LOGGER.error(ex.getMessage(), ex);
				dialogDisplayer.showErrorDialogSync("Trac", ex.getMessage(), null);
			}
		}
	}
}