package com.syntevo.plugin.trac.commit.workflow;

import java.util.*;

import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.gui.*;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.*;
import com.syntevo.openapi.deprecated.smartsvn.settings.*;

/**
 * @author syntevo GmbH
 */
final class TracCommitWorkflow extends FilterCommitWorkflow {

	// Fields =================================================================

	private final List<ICommitPacketPhase> packetPhases;
	private final CommitWorkflowServices services;

	private TracFilesPhase filesPhase;

	// Setup ==================================================================

	public TracCommitWorkflow(@NotNull ICommitWorkflow baseWorkflow, @NotNull CommitWorkflowServices services, @NotNull SettingsServices settingsServices, @NotNull GuiSpacings spacings) {
		super(baseWorkflow);

		this.services = services;
		packetPhases = new ArrayList<>();

		for (ICommitPacketPhase phase : new ArrayList<>(baseWorkflow.getPacketPhases())) {
			if (phase.getID().equals("files")) {
				filesPhase = new TracFilesPhase(phase, settingsServices, services.getPacketPhaseJobRunner(), spacings, services.getPacketPhaseDialogDisplayer());
				packetPhases.add(filesPhase);
			}
			else {
				packetPhases.add(phase);
			}
		}
	}

	// Implemented ============================================================

	@Override
	@NotNull
	public List<ICommitPacketPhase> getPacketPhases() {
		return packetPhases;
	}

	@Override
	@NotNull
	public ICommitPostCommandPhase getPostCommandPhase() {
		final ICommitPostCommandPhase wrappedPhase = super.getPostCommandPhase();

		if (filesPhase == null) {
			return wrappedPhase;
		}

		final List<TracResolvePacket> resolvePackets = filesPhase.getResolvePackets();

		if (resolvePackets == null || resolvePackets.isEmpty()) {
			return wrappedPhase;
		}

		return new TracPostCommandPhase(wrappedPhase, resolvePackets, services.getPrePostCommandPhaseDialogDisplayer());
	}
}