package com.syntevo.plugin.trac.commit.messagesource;

import org.jetbrains.annotations.*;

import com.syntevo.plugin.trac.commit.*;

/**
 * @author syntevo GmbH
 */
final class TracQueryConfiguration {

	// Fields =================================================================

	private final TracUIConnection connection;
	private final boolean loadAll;

	// Setup ==================================================================

	public TracQueryConfiguration(@NotNull TracUIConnection connection, boolean loadAll) {
		this.loadAll = loadAll;
		this.connection = connection;
	}

	// Accessing =============================================================

	@NotNull
	public TracUIConnection getConnection() {
		return connection;
	}

	public boolean isLoadAll() {
		return loadAll;
	}
}