package com.syntevo.plugin.trac.commit.messagesource;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.gui.dialog.*;
import com.syntevo.openapi.deprecated.util.*;

/**
 * @author syntevo GmbH
 */
public class TracConfigureCommitMessagePatternDialog extends AbstractOkCancelDialog {
	public static final String PLACEHOLDER_MESSAGE = "%MESSAGE%";
	public static final String PLACEHOLDER_BUGID = "%BUGID%";
	
	private static final String MESSAGE_PATTERN_TITLE = "Please define the commit message pattern:";

	private String commitMessagePattern = null;
	private final String defaultMessagePattern;
	private Text messageEditor;

	public TracConfigureCommitMessagePatternDialog(@Nullable String defaultMessagePattern) {
		this.defaultMessagePattern = defaultMessagePattern;
	}

	@NotNull
	@Override
	public Control createComponent(@NotNull Composite parent) {
		final Composite panel = new Composite(parent, SWT.NONE) {
			@Override
			public Point computeSize(int wHint, int hHint, boolean changed) {
				return new Point(400, 100);
			}
		};

		final GridLayout layout = new GridLayout(1, false);
		panel.setLayout(layout);

		final Label editorLabel = UiUtils.createLabel(MESSAGE_PATTERN_TITLE, panel);
		editorLabel.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false));
		
		messageEditor = UiUtils.createTextArea(defaultMessagePattern, panel);
		messageEditor.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 3));

		return panel;
	}

	@NotNull
	@Override
	public String getTitle() {
		return "Configure commit message pattern";
	}

	@Override
	protected void ok() throws DialogValidationFailedException {
		commitMessagePattern = messageEditor.getText();
		super.ok();
	}

	public String getCommitMessagePattern() {
		return commitMessagePattern;
	}
}