package com.syntevo.plugin.trac.commit.messagesource;

import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.gui.*;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.*;
import com.syntevo.openapi.deprecated.smartsvn.file.*;
import com.syntevo.openapi.deprecated.smartsvn.settings.*;
import com.syntevo.openapi.deprecated.util.*;
import com.syntevo.plugin.common.bugtracker.commit.messagesource.*;
import com.syntevo.plugin.trac.commit.*;

/**
 * @author syntevo GmbH
 */
public final class TracCommitMessageSourceFactory implements ICommitMessageSourceFactory {

	// Fields =================================================================

	private final SettingsServices settingsServices;
	private final GuiSpacings spacings;

	// Setup ==================================================================

	public TracCommitMessageSourceFactory(SettingsServices settingsServices, GuiSpacings spacings) {
		this.settingsServices = settingsServices;
		this.spacings = spacings;
	}

	// Implemented ============================================================

	@Override
	@Nullable
	public ICommitMessageSource createCommitMessageSource(@Nullable CommitMessageSourceServices sourceServices) {
		sourceServices = Assert.assertNotNull(sourceServices);
		final Thread currentThread = Thread.currentThread();
		final ClassLoader originalContextClassLoader = currentThread.getContextClassLoader();

		currentThread.setContextClassLoader(getClass().getClassLoader());

		try {
			final Path commitRootPath = sourceServices.getCommitRootPath();
			final String bugtraqURL = BugtrackerCommitMessageSourceUtils.findBugtraqURL(sourceServices.getClients(), commitRootPath);

			if (bugtraqURL == null) {
				return null;
			}

			final TracUrl url = TracUrl.parseFromBugtraqUrls(bugtraqURL);

			if (url == null) {
				return null;
			}

			return new TracCommitMessageSource(url.getBaseUrl(), settingsServices, sourceServices.getBugtraqProperties(), spacings, sourceServices.getDialogDisplayer());
		}
		finally {
			currentThread.setContextClassLoader(originalContextClassLoader);
		}
	}
}