package com.syntevo.plugin.trac.commit;

import org.jetbrains.annotations.*;

/**
 * @author syntevo GmbH
 */
public class TracUrl {

	// Constants ==============================================================

	private static final String TICKET_SIGNATURE = "/ticket/";
	private static final String JSON_RPC_SUFFIX = "/login/jsonrpc";

	// Static =================================================================

	@Nullable
	public static TracUrl parseFromBugtraqUrls(@Nullable String url) {
		if (url == null) {
			return null;
		}

		final String baseUrl = extractBaseURL(url);

		if (baseUrl == null) {
			return null;
		}

		return new TracUrl(baseUrl + JSON_RPC_SUFFIX);
	}

	// Fields =================================================================

	private final String baseUrl;

	// Setup ==================================================================

	public TracUrl(@NotNull String baseUrl) {
		this.baseUrl = baseUrl;
	}

	// Implemented ============================================================

	@Override
	public String toString() {
		return baseUrl;
	}

	// Accessing ==============================================================

	@NotNull
	public String getBaseUrl() {
		return baseUrl;
	}

	// Utils ==================================================================

	@Nullable
	private static String extractBaseURL(@NotNull String url) {
		final String signature = findSignature(url);
		if (signature == null) {
			return null;
		}

		final int signatureIndex = url.indexOf(signature);
		url = url.substring(0, signatureIndex);

		return url;
	}

	@Nullable
	private static String findSignature(@NotNull String url) {
		if (url.contains(TICKET_SIGNATURE)) {
			return TICKET_SIGNATURE;
		}

		return null;
	}
}