package com.syntevo.plugin.trac.commit;

import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.gui.*;
import com.syntevo.openapi.deprecated.gui.dialog.*;
import com.syntevo.openapi.deprecated.smartsvn.settings.*;
import com.syntevo.plugin.common.bugtracker.transport.*;
import com.syntevo.plugin.trac.*;

/**
 * @author syntevo GmbH
 */
public final class TracUIConnection extends BugtrackerUIConnection {

	// Constants ==============================================================

	private static final String PLUGIN_NAME = "Trac";
	private static final String KEY_COMMIT_MESSAGE_PATTERN = "commit-message-pattern";
	private static final boolean DEBUG_LOGGING = Boolean.getBoolean("smartsvn.plugin.trac.debug-logging");
	private static final String PLUGIN_SETTINGS_FILE = "trac-plugin.log";
	private static final String CREDENTIALS_DIALOG_TITLE = PLUGIN_NAME + " - Login";
	private static final String CERTIFICATE_DIALOG_TITLE = PLUGIN_NAME + " - Client Certificate";

	// Setup ==================================================================

	public TracUIConnection(@NotNull String url, @NotNull SettingsServices settingsServices, boolean silent, @NotNull GuiSpacings spacings, @NotNull DialogDisplayer dialogDisplayer) {
		super(url.endsWith("/") ? url.substring(0, url.length() - 1) : url,
		      PLUGIN_NAME,
		      settingsServices.getGlobalSettingsProvider().getSettings(TracPlugin.PLUGIN_ID),
		      settingsServices.getSettingsFile(PLUGIN_SETTINGS_FILE),
		      silent,
		      DEBUG_LOGGING,
		      CREDENTIALS_DIALOG_TITLE,
		      CERTIFICATE_DIALOG_TITLE,
		      spacings,
		      dialogDisplayer);
	}

	// Accessing ==============================================================

	@Nullable
	public String getCommitMessagePattern() {
		return retrieveValue(getUrl(), KEY_COMMIT_MESSAGE_PATTERN);
	}

	public void storeCommitMessagePattern(@Nullable String commitMessagePattern) {
		storeValue(getUrl(), KEY_COMMIT_MESSAGE_PATTERN, commitMessagePattern, Boolean.TRUE);
	}
}