package com.syntevo.plugin.tagmultiple;

import java.util.*;

import org.apache.subversion.javahl.*;
import org.apache.subversion.javahl.types.*;

import com.syntevo.openapi.deprecated.smartsvn.command.*;
import com.syntevo.openapi.deprecated.smartsvn.file.*;
import com.syntevo.openapi.deprecated.smartsvn.tagbranch.*;
import com.syntevo.openapi.deprecated.smartsvn.thread.*;
import com.syntevo.openapi.deprecated.util.*;

/**
 * @author syntevo GmbH
 */
final class TagMultipleProjectRootsSvnCommand implements ISvnCommand {

	// Fields =================================================================

	private final String tagName;
	private final Set<? extends SvnDirectory> svnDirectories;
	private final boolean fixExternalsRevisions;
	private final SvnTagBranchLayouts svnTagBranchLayouts;
	private final String commitMessage;

	// Setup ==================================================================

	public TagMultipleProjectRootsSvnCommand(String tagName, Set<? extends SvnDirectory> svnDirectories, boolean fixExternalsRevisions, SvnTagBranchLayouts svnTagBranchLayouts, String commitMessage) {
		this.tagName = tagName;
		this.svnDirectories = svnDirectories;
		this.fixExternalsRevisions = fixExternalsRevisions;
		this.svnTagBranchLayouts = svnTagBranchLayouts;
		this.commitMessage = commitMessage;
	}

	// Implemented ============================================================

	@Override
	public void perform(SvnClients svnClients, ProgressViewer progressViewer) throws SubversionException {
		final Map<SvnDirectory, String> directoryToLayout = new HashMap<>();
		for (SvnDirectory svnDirectory : svnDirectories) {
			final SvnTagBranchLayout layout = svnTagBranchLayouts.getTrunkTagBranchLayout(svnDirectory.getURLString());
			if (layout == null) {
				throw new PluginException("No tag branch layout found for " + svnDirectory.getPath());
			}

			final String tagLocation = layout.getTagLocation(tagName);
			if (tagLocation == null) {
				throw new PluginException("Can't determine tag location for " + svnDirectory.getPath());
			}

			directoryToLayout.put(svnDirectory, tagLocation);
		}

		int ii = 0;
		for (final Iterator<? extends SvnDirectory> it = svnDirectories.iterator(); it.hasNext(); ii++) {
			final SvnDirectory svnDirectory = it.next();
			final String tagLocation = directoryToLayout.get(svnDirectory);
			progressViewer.setMessage("Tagging " + svnDirectory.getPath().getFile().getAbsolutePath() + " ...");
			progressViewer.setProgress(ii, svnDirectories.size());

			final ISVNClient svnClient = svnClients.createClient();
			try {
				final CopySource copySource = new CopySource(svnDirectory.getPath().getFile().getAbsolutePath(), Revision.WORKING, Revision.WORKING);
				svnClient.copy(Collections.singletonList(copySource), tagLocation, true, true, false, false, fixExternalsRevisions, null, null, svnClients.getCommitMessageCallback(commitMessage), null);
			} finally {
				svnClient.dispose();
			}
		}
	}
}
