package com.syntevo.plugin.tagmultiple;

import com.syntevo.openapi.deprecated.smartsvn.*;
import com.syntevo.openapi.deprecated.smartsvn.action.*;
import com.syntevo.openapi.deprecated.smartsvn.gui.menu.*;

/**
 * @author syntevo GmbH
 */
final class TagMultipleProjectRootsActionProvider implements IActionProvider {

	// Fields =================================================================

	private final SmartSvnServices services;

	// Setup ==================================================================

	public TagMultipleProjectRootsActionProvider(SmartSvnServices services) {
		this.services = services;
	}

	// Implemented ============================================================

	@Override
	public void modifyMenuBar(MenuContainer menuContainer) {
		final boolean inserted = MenuUtils.insertActionAfter(ProjectActionIds.TAG_ADD_TAG, TagMultipleProjectRootsAction.ID, 0, "Tag Multiple Project Roots...", "Add a tag to multiple project roots.", false, true, menuContainer);
		if (!inserted) {
			TagMultipleProjectRootsPlugin.LOG.error("menu item not found");
		}
	}

	@Override
	public void createActions(ActionRegisterService service) {
		service.registerAction(TagMultipleProjectRootsAction.ID, new TagMultipleProjectRootsAction(services));
	}
}
