package com.syntevo.plugin.removeemptydirectories;

import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.gui.dialog.*;
import com.syntevo.openapi.deprecated.smartsvn.action.*;
import com.syntevo.openapi.deprecated.smartsvn.file.*;
import com.syntevo.openapi.deprecated.smartsvn.file.gui.*;

/**
 * @author syntevo GmbH
 */
final class REDFileDirectoryAction implements ISvnFileDirectoryAction {

	// Constants ==============================================================

	public static final String ID = RemoveEmptyDirectoriesPlugin.ID + ".RemoveEmptyDirectories";

	// Setup ==================================================================

	public REDFileDirectoryAction() {
	}

	// Implemented ============================================================

	@Override
	public boolean isApplicable(@NotNull SelectedSvnFiles selectedFiles, @NotNull SelectedSvnDirectories selectedDirectories) {
		final SvnDirectory directory = selectedDirectories.getDirectory();
		if (directory == null) {
			return false;
		}

		final SvnDirectoryLocalState state = directory.getLocalState();
		return state == SvnDirectoryLocalState.CONFLICT
				|| state == SvnDirectoryLocalState.COPIED
				|| state == SvnDirectoryLocalState.HISTORY_SCHEDULED
				|| state == SvnDirectoryLocalState.HISTORY_SCHEDULED_MODIFIED
				|| state == SvnDirectoryLocalState.NESTED_ROOT
				|| state == SvnDirectoryLocalState.MODIFIED
				|| state == SvnDirectoryLocalState.UNCHANGED;
	}

	@Override
	public void execute(@NotNull SelectedSvnFiles files, @NotNull SvnEntryQuery entryQuery, @NotNull ActionServices services) {
		throw new UnsupportedOperationException();
	}

	@Override
	public void execute(@NotNull final SelectedSvnDirectories directories, @NotNull SvnEntryQuery entryQuery, @NotNull final ActionServices services) {
		services.getDialogDisplayer().showConfirmationDialogAsync("Remove Empty Directories", "Do you want to start searching for empty directories?",
		                                                          "Found empty directories will be marked for removal.", "Start", false, new IDialogResultHandler() {
			@Override
			public void handleDialogResult(int value) {
				if (value != AbstractDialog.RESULT_OK) {
					return;
				}

				services.scheduleCommand(new REDSvnCommand(directories.getDirectory()), "Remove Empty Directories");
			}
		});
	}
}
