package com.syntevo.plugin.precommithook;

import java.io.*;
import java.util.concurrent.*;

import com.syntevo.openapi.deprecated.log.*;

/**
 * @author syntevo GmbH
 */
final class PreCommitHookStreamGobbler implements Runnable {

	// Fields =================================================================

	private final String name;
	private final InputStream is;
	private final Semaphore threadWaiter;
	private final Logger logger;

	private IOException exception;

	// Setup ==================================================================

	public PreCommitHookStreamGobbler(String name, InputStream is, Semaphore threadWaiter) {
		this.name = name;
		this.is = is;
		this.threadWaiter = threadWaiter;
		this.logger = LoggerFactory.createLogger("smartsvn.pre-commit-hook." + name);
	}

	// Implemented ============================================================

	@Override
	public void run() {
		try {
			ByteArrayOutputStream bos = new ByteArrayOutputStream();
			for (int ch = is.read(); ch != -1; ch = is.read()) {
				if (ch == '\r') {
					continue;
				}

				if (ch == '\n') {
					logger.info(bos.toString());
					bos = new ByteArrayOutputStream();
					continue;
				}

				bos.write(ch);
			}

			if (bos.size() > 0 ) {
				logger.info(bos.toString());
			}
		}
		catch (IOException ex) {
			logger.error("error reading " + name, ex);
			exception = ex;
		}
		finally {
			if (threadWaiter != null) {
				threadWaiter.release();
			}
		}
	}

	// Accessing ==============================================================

	public void throwException() throws IOException {
		if (exception != null) {
			throw exception;
		}
	}
}
