package com.syntevo.plugin.mergeinfocolumn;

import org.eclipse.swt.graphics.*;

import com.syntevo.openapi.deprecated.gui.table.*;
import com.syntevo.openapi.deprecated.util.*;

/**
 * @author syntevo GmbH
 */
final class MergeInfoTableColumn implements ITableColumn<Object> {

	// Implemented ============================================================

	@Override
	public String getColumnName() {
		return "Merge Info";
	}

	@Override
	public boolean isRightAligned() {
		return false;
	}

	@Override
	public String getText(Object row) {
		return MergeInfoType.internalToType(row).getName();
	}

	@Override
	public Image getImage(Object rowObject) {
		return null;
	}

	@Override
	public int compare(Object row1, Object row2) {
		return CompareUtils.compare(MergeInfoType.internalToType(row1).getValue(), MergeInfoType.internalToType(row2).getValue());
	}
}
