package com.syntevo.plugin.mergeinfocolumn;

import com.syntevo.openapi.deprecated.gui.table.*;
import com.syntevo.openapi.deprecated.smartsvn.file.*;
import com.syntevo.openapi.deprecated.smartsvn.file.gui.*;

/**
 * @author syntevo GmbH
 */
final class MergeInfoFileTableColumn implements ISvnFileTableColumn {

	// Fields =================================================================

	private final MergeInfoTableColumn tableColumn = new MergeInfoTableColumn();

	// Setup ==================================================================

	public MergeInfoFileTableColumn() {
	}

	// Implemented ============================================================

	@Override
	public Object getValue(SvnFileExtendedAttributes attributes) {
		return attributes.getAttribute(SvnProperty.MERGE_INFO);
	}

	@Override
	public boolean handleProperty(SvnFileExtendedAttributesBuilder attributes, SvnProperty property) {
		if (!SvnProperty.MERGE_INFO.equals(property.getName())) {
			return false;
		}

		attributes.setAttribute(SvnProperty.MERGE_INFO, MergeInfoType.stringToInternal(property.getString()));
		return true;
	}

	@Override
	public ITableColumn<Object> getTableColumn() {
		return tableColumn;
	}

	@Override
	public boolean isShowInitially() {
		return false;
	}
}
