package com.syntevo.plugin.mergeinfocolumn;

import com.syntevo.openapi.deprecated.smartsvn.file.*;
import com.syntevo.openapi.deprecated.smartsvn.file.gui.*;

/**
 * @author syntevo GmbH
 */
final class MergeInfoFileFilter implements ISvnFileFilter {

	// Implemented ============================================================

	@Override
	public boolean handleProperty(SvnFileExtendedAttributesBuilder attributes, SvnProperty property) {
		if (!SvnProperty.MERGE_INFO.equals(property.getName())) {
			return false;
		}

		attributes.setAttribute(SvnProperty.MERGE_INFO, MergeInfoType.stringToInternal(property.getString()));
		return true;
	}

	@Override
	public String getFilterName() {
		return "Merge Info";
	}

	@Override
	public boolean doesMatch(SvnFileExtendedAttributes attributes, String text, boolean regularExpression) {
		if (text == null) {
			text = "";
		}
		
		final MergeInfoType mergeInfo = (MergeInfoType)attributes.getAttribute(SvnProperty.MERGE_INFO);
		if (mergeInfo == null) {
			return "".equals(text);
		}
		return text.toLowerCase().equals(mergeInfo.getName().toLowerCase());
	}
}