package com.syntevo.plugin.mergeinfocolumn;

import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.*;
import com.syntevo.openapi.deprecated.smartsvn.*;

/**
 * @author syntevo GmbH
 */
public final class MergeInfoColumnPlugin implements IActivator {

	// Constants ==============================================================

	private static final boolean FILTER = Boolean.getBoolean("smartsvn.plugin.merge-info.file-filter");

	// Implemented ============================================================

	@Override
	public void initialize(@NotNull SmartSvnServices services) {
		services.addFileTableColumn(new MergeInfoFileTableColumn());
		if (FILTER) {
			services.addFileFilter(new MergeInfoFileFilter());
		}
	}
}
