package com.syntevo.plugin.jira.transport;

/**
 * @author syntevo GmbH
 */
public class JiraVersion {

	// Fields =================================================================

	private final String id;
	private final String name;

	// Setup ==================================================================

	public JiraVersion(String id, String name) {
		this.id = id;
		this.name = name;
	}

	// Implemented ============================================================

	@Override
	public String toString() {
		return id + " (" + name + ")";
	}

	@Override
	public int hashCode() {
		return id.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null || obj.getClass() != getClass()) {
			return false;
		}

		final JiraVersion version = (JiraVersion)obj;
		return id.equals(version.id) && name.equals(version.name);
	}

	// Accessing ==============================================================

	public String getId() {
		return id;
	}

	public String getName() {
		return name;
	}
}