package com.syntevo.plugin.jira.transport;

import java.util.*;

/**
 * @author syntevo GmbH
 */
public final class JiraIssueType {

	// Constants ==============================================================

	public static final JiraIssueType BUG = new JiraIssueType("bug", "1");
	public static final JiraIssueType NEW_FEATURE = new JiraIssueType("new-feature", "2");
	public static final JiraIssueType TASK = new JiraIssueType("task", "3");
	public static final JiraIssueType IMPROVEMENT = new JiraIssueType("improvement", "4");
	public static final JiraIssueType UNKNOWN = new JiraIssueType("unknown", null);
	public static final List<JiraIssueType> ALL = Collections.unmodifiableList(Arrays.asList(BUG, NEW_FEATURE, TASK, IMPROVEMENT, UNKNOWN));

	// Static =================================================================

	public static JiraIssueType parseFromId(String id) {
		for (JiraIssueType type : ALL) {
			if (type.jiraId != null && type.jiraId.equals(id)) {
				return type;
			}
		}

		return UNKNOWN;
	}

	// Fields =================================================================

	private final String id;
	private final String jiraId;

	// Setup ==================================================================

	public JiraIssueType(String id, String jiraId) {
		this.id = id;
		this.jiraId = jiraId;
	}

	// Implemented ============================================================

	@Override
	public String toString() {
		return id;
	}
}