package com.syntevo.plugin.jira.transport;

import java.util.*;

/**
 * @author syntevo GmbH
 */
public final class JiraIssueStatus {

	// Constants ==============================================================

	// As received from SOAP interface getStatuses().
	public static final JiraIssueStatus IN_PROGRESS = new JiraIssueStatus("in-progress", "3", "In progress", 0);
	public static final JiraIssueStatus OPEN = new JiraIssueStatus("open", "1", "Open", 1);
	public static final JiraIssueStatus REOPENED = new JiraIssueStatus("reopened", "4", "Reopened", 2);
	public static final JiraIssueStatus RESOLVED = new JiraIssueStatus("resolved", "5", "Resolved", 3);
	public static final JiraIssueStatus CLOSED = new JiraIssueStatus("closed", "6", "Closed", 4);
	public static final JiraIssueStatus UNKNOWN = new JiraIssueStatus("unknown", null, "???", -1);
	public static final List<JiraIssueStatus> ALL = Collections.unmodifiableList(Arrays.asList(OPEN, IN_PROGRESS, RESOLVED, REOPENED, CLOSED, UNKNOWN));

	// Static =================================================================

	public static JiraIssueStatus parseFromId(String jiraId) {
		for (JiraIssueStatus status : ALL) {
			if (status.jiraId != null && status.jiraId.equals(jiraId)) {
				return status;
			}
		}
		
		return UNKNOWN;
	}

	// Fields =================================================================

	private final String id;
	private final String jiraId;
	private final String name;
	private final int relevance;

	// Setup ==================================================================

	public JiraIssueStatus(String id, String jiraId, String name, int relevance) {
		this.id = id;
		this.jiraId = jiraId;
		this.name = name;
		this.relevance = relevance;
	}

	// Implemented ============================================================

	@Override
	public String toString() {
		return id;
	}

	// Accessing ==============================================================

	public String getJiraId() {
		return jiraId;
	}

	public String getName() {
		return name;
	}

	public int getRelevance() {
		return relevance;
	}
}