package com.syntevo.plugin.jira.transport;

import java.util.*;

/**
 * @author syntevo GmbH
 */
public final class JiraIssueResolution {

	// Constants ==============================================================

	public static final JiraIssueResolution FIXED = new JiraIssueResolution("fixed", "1");
	public static final JiraIssueResolution WONT_FIX = new JiraIssueResolution("wont-fix", "2");
	public static final JiraIssueResolution INCOMPLETE = new JiraIssueResolution("incomplete", "3");
	public static final JiraIssueResolution DUPLICATE = new JiraIssueResolution("duplicate", "4");
	public static final JiraIssueResolution CANNOT_REPRODUCE = new JiraIssueResolution("cannot-reproduce", "5");
	public static final JiraIssueResolution UNKNOWN = new JiraIssueResolution("unknown", null);
	public static final List<JiraIssueResolution> ALL = Collections.unmodifiableList(Arrays.asList(FIXED, WONT_FIX, INCOMPLETE, DUPLICATE, CANNOT_REPRODUCE, UNKNOWN));

	// Static =================================================================

	public static JiraIssueResolution parseFromId(String id) {
		for (JiraIssueResolution resolution : ALL) {
			if (resolution.jiraId != null && resolution.jiraId.equals(id)) {
				return resolution;
			}
		}
		
		return UNKNOWN;
	}

	// Fields =================================================================

	private final String id;
	private final String jiraId;

	// Setup ==================================================================

	public JiraIssueResolution(String id, String jiraId) {
		this.id = id;
		this.jiraId = jiraId;
	}

	// Implemented ============================================================

	@Override
	public String toString() {
		return id;
	}

	// Accessing ==============================================================

	public String getJiraId() {
		return jiraId;
	}
}