package com.syntevo.plugin.jira.commit.workflow;

import com.syntevo.openapi.deprecated.gui.*;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.*;
import com.syntevo.openapi.deprecated.smartsvn.settings.*;

/**
 * @author syntevo GmbH
 */
public final class JiraCommitWorkflowFactory implements ICommitWorkflowFactory {

	// Fields =================================================================

	private final SettingsServices settingsServices;
	private final GuiSpacings spacings;

	// Setup ==================================================================

	public JiraCommitWorkflowFactory(SettingsServices settingsServices, GuiSpacings spacings) {
		this.settingsServices = settingsServices;
		this.spacings = spacings;
	}

	// Implemented ============================================================

	@Override
	public ICommitWorkflow createWorkflow(ICommitWorkflow baseWorkflow, CommitWorkflowServices services) {
		return new JiraCommitWorkflow(baseWorkflow, services, settingsServices, spacings);
	}
}