package com.syntevo.plugin.jira.commit.messagesource;

import com.syntevo.plugin.jira.commit.*;

/**
 * @author syntevo GmbH
 */
final class JiraQueryConfiguration {

	// Fields =================================================================

	private final JiraUIConnection connection;
	private final String projectKey;
	private final boolean loadAll;

	// Setup ==================================================================

	public JiraQueryConfiguration(JiraUIConnection connection, String projectKey, boolean loadAll) {
		this.projectKey = projectKey;
		this.loadAll = loadAll;
		this.connection = connection;
	}

	// Accessing =============================================================

	public String getProjectKey() {
		return projectKey;
	}

	public JiraUIConnection getConnection() {
		return connection;
	}

	public boolean isLoadAll() {
		return loadAll;
	}
}