package com.syntevo.plugin.jira.commit.messagesource;

import java.io.*;
import java.util.*;

import org.jetbrains.annotations.*;

import com.syntevo.plugin.jira.transport.*;

/**
 * @author syntevo GmbH
 */
final class JiraIssueLoaderTableUpdater {

	// Fields =================================================================

	private final JiraQueryClient client;
	private final JiraIssueList issueList;
	private final JiraIssueTable table;

	private boolean aborted;

	// Setup ==================================================================

	public JiraIssueLoaderTableUpdater(JiraQueryClient client, JiraIssueList issueList, JiraIssueTable table) {
		this.client = client;
		this.issueList = issueList;
		this.table = table;
	}

	// Accessing ==============================================================

	public void load(String projectId, @Nullable String assignee, List<JiraIssueStatus> stati, List<String> fixVersions, int relevance) throws IOException {
		boolean start = true;
		while (!aborted) {
			final List<JiraIssue> fetchedIssues;
			if (start) {
				start = false;
				fetchedIssues = client.getFirstIssues(projectId, assignee, stati, fixVersions, 100);
			}
			else {
				fetchedIssues = client.getNextIssues(100);
			}

			issueList.addIssues(fetchedIssues, relevance);
			table.setIssues(issueList.getIssuesInOrder());

			if (fetchedIssues.isEmpty()) {
				return;
			}
		}
	}

	public void abort() {
		aborted = true;
	}
}