package com.syntevo.plugin.jira.commit.messagesource;

import java.util.*;
import java.util.List;

import org.eclipse.swt.widgets.*;
import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.gui.*;
import com.syntevo.openapi.deprecated.gui.dialog.*;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.*;
import com.syntevo.openapi.deprecated.smartsvn.settings.*;
import com.syntevo.openapi.deprecated.util.*;
import com.syntevo.plugin.jira.commit.*;
import com.syntevo.plugin.jira.transport.*;

/**
 * @author syntevo GmbH
 */
final class JiraCommitMessageSource implements ICommitMessageSource, JiraIssueTable {

	// Fields =================================================================

	private final DialogDisplayer dialogDisplayer;
	private final JiraIssueLoader issueLoader;
	private final JiraQueryConfiguration queryConfiguration;

	private List<JiraIssue> pendingIssues = new ArrayList<>();
	private JiraCommitMessageSourceDialog currentDialog;

	// Setup ==================================================================

	public JiraCommitMessageSource(String baseUrl, SettingsServices settingsServices, String projectKey, GuiSpacings spacings, DialogDisplayer dialogDisplayer) {
		this.dialogDisplayer = dialogDisplayer;

		issueLoader = new JiraIssueLoader(this);
		issueLoader.start();

		final boolean loadAll = "true".equals(System.getProperty("smartsvn.plugin.jira.loadAllIssues", System.getProperty("smartsvn.plugin.jira.load-all-issues", "false")));
		queryConfiguration = new JiraQueryConfiguration(new JiraUIConnection(baseUrl, settingsServices, false, spacings, dialogDisplayer), projectKey, loadAll);

		final JiraQueryConfiguration silentQueryConfiguration = new JiraQueryConfiguration(new JiraUIConnection(baseUrl, settingsServices, true, spacings, dialogDisplayer), projectKey, loadAll);
		issueLoader.load(silentQueryConfiguration, true);
	}

	// Implemented ============================================================

	@Override
	@NotNull
	public String getMenuItemName() {
		return "Get from JIRA...";
	}

	@Override
	public void getCommitMessage(@NotNull final Consumer<String> consumer) {
		final JiraCommitMessageSourceDialog dialog = new JiraCommitMessageSourceDialog(pendingIssues, issueLoader, queryConfiguration);
		currentDialog = dialog;

		issueLoader.load(queryConfiguration, false);
		dialogDisplayer.showAsync(currentDialog, new IDialogResultHandler() {
			@Override
			public void handleDialogResult(int value) {
				currentDialog = null;
				if (value == AbstractDialog.RESULT_OK) {
					consumer.consumer(dialog.getCommitMessage());
				}
			}
		});
	}

	@Override
	public void cleanup() {
		issueLoader.abortAndCleanup();
	}

	@Override
	public void setIssues(final List<JiraIssue> issues) {
		Display.getDefault().asyncExec(new Runnable() {
			@Override
			public void run() {
				pendingIssues = new ArrayList<>(issues);
				if (currentDialog != null) {
					currentDialog.setIssues(pendingIssues);
				}
			}
		});
	}
}