package com.syntevo.plugin.jira;

import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.*;
import com.syntevo.openapi.deprecated.log.*;
import com.syntevo.openapi.deprecated.smartsvn.*;
import com.syntevo.plugin.jira.commit.messagesource.*;
import com.syntevo.plugin.jira.commit.workflow.*;

/**
 * @author syntevo GmbH
 */
public final class JiraPlugin implements IActivator {

	// Constants ==============================================================

	public static final String PLUGIN_ID = "com.syntevo.jira";
	public static final Logger LOGGER = LoggerFactory.createLogger(PLUGIN_ID);

	// Implemented ============================================================

	@Override
	public void initialize(@NotNull SmartSvnServices services) {
		services.addCommitMessageSourceFactory(new JiraCommitMessageSourceFactory(services.getSettingsServices(), services.getGuiSpacings()));
		services.addCommitWorkflowFactory(new JiraCommitWorkflowFactory(services.getSettingsServices(), services.getGuiSpacings()));
	}
}
