<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:date="http://exslt.org/dates-and-times" xmlns:func="http://exslt.org/functions"
                xmlns:str="http://exslt.org/strings" extension-element-prefixes="date func str" version="1.0">

	<xsl:output omit-xml-declaration="yes" indent="yes" encoding="UTF-8" method="xml"/>

	<xsl:template match="log">
		<html>
			<head>Log</head>
			<body>
				<ul>
					<xsl:apply-templates select="logentry"/>
				</ul>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="logentry">
		<li>
			r<b><xsl:value-of select="@revision"/></b>
			(<xsl:call-template name="formatDate">
        <xsl:with-param name="isodate" select="date" />
      </xsl:call-template>)
			by <b><xsl:value-of select="author"/></b>: <xsl:value-of select="msg"/>
			<xsl:apply-templates select="paths"/>
		</li>
	</xsl:template>

	<xsl:template match="paths">
		<ul>
			<xsl:apply-templates select="path"/>
		</ul>
	</xsl:template>

	<xsl:template match="path">
		<li>
			<xsl:value-of select="."/><xsl:if test="@kind = 'dir'">/</xsl:if>

			<xsl:text> (</xsl:text><i>
			<xsl:choose>
				<xsl:when test="@action = 'A'">
					<xsl:choose>
						<xsl:when test="@copyfrom-path">
							<xsl:text>copied from </xsl:text><xsl:value-of select ="@copyfrom-path"/><xsl:text>@</xsl:text><xsl:value-of select ="@copyfrom-rev"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>added</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="@action = 'D'">deleted</xsl:when>
				<xsl:when test="@action = 'M'">modified</xsl:when>
				<xsl:when test="@action = 'R'">replaced</xsl:when>
				<xsl:otherwise>changed</xsl:otherwise>
			</xsl:choose></i>
			<xsl:text>)</xsl:text>
		</li>
	</xsl:template>

	<xsl:template name="formatDate">
		<xsl:param name="isodate"/>
		<xsl:variable name="date" select="substring-before($isodate, 'T')" />
		<xsl:variable name="time" select="substring-before(substring-after($isodate, 'T'), '.')" />

		<xsl:variable name="year" select="substring-before($date, '-')" />
		<xsl:variable name="month" select="substring-before(substring-after($date, '-'), '-')" />
		<xsl:variable name="day" select="substring-after(substring-after($date, '-'), '-')" />

		<xsl:variable name="hour" select="substring-before($time, ':')" />
		<xsl:variable name="minute" select="substring-before(substring-after($time, ':'), ':')" />
		<xsl:variable name="second" select="substring-after(substring-after($time, ':'), ':')" />

		<xsl:value-of select="concat($year, '-', $month, '-', $day, ' ', $hour, ':', $minute, ':', $second)" />
	</xsl:template>
</xsl:stylesheet>
