/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.hidemenuitems;

import com.syntevo.openapi.deprecated.IActivator;
import com.syntevo.openapi.deprecated.log.Logger;
import com.syntevo.openapi.deprecated.log.LoggerFactory;
import com.syntevo.openapi.deprecated.smartsvn.SmartSvnServices;
import com.syntevo.openapi.deprecated.smartsvn.action.IActionProvider;
import com.syntevo.openapi.deprecated.smartsvn.gui.menu.ProjectActionIds;
import com.syntevo.plugin.hidemenuitems.HideMenuItemsActionProvider;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class HideMenuItemsPlugin
implements IActivator {
    static final Logger LOG = LoggerFactory.createLogger((String)"com.syntevo.hideMenuItems");
    private static final String CONFIG_FILE_NAME = "menuItemsToHide.config";

    public void initialize(@NotNull SmartSvnServices services) {
        File userConfigFile = services.getSettingsServices().getSettingsFile(CONFIG_FILE_NAME);
        File configFile = userConfigFile;
        if (!configFile.exists() && !(configFile = services.getSettingsServices().getDefaultSettingsFile(CONFIG_FILE_NAME)).exists()) {
            this.createDefaultConfigFile(userConfigFile);
            return;
        }
        Set idsToHide = this.readConfigFile(configFile);
        if (idsToHide.isEmpty()) {
            return;
        }
        services.addProjectActionProvider((IActionProvider)new HideMenuItemsActionProvider(idsToHide));
    }

    private Set readConfigFile(File configFile) {
        HashSet<String> idsToHide = new HashSet<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(configFile));){
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).startsWith("#")) {
                    idsToHide.add(line);
                }
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            LOG.error("Error reading config file " + configFile.getAbsolutePath(), (Throwable)ex);
        }
        return idsToHide;
    }

    private void createDefaultConfigFile(File configFile) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(configFile));){
            writer.write("# Uncomment entries to hide them");
            writer.newLine();
            ArrayList sortedIds = new ArrayList(ProjectActionIds.ALL_IDS);
            Collections.sort(sortedIds);
            Iterator it = sortedIds.iterator();
            while (it.hasNext()) {
                this.writeLine((String)it.next(), writer);
            }
        }
        catch (IOException ex) {
            LOG.error("Error writing config file " + configFile.getAbsolutePath(), (Throwable)ex);
        }
    }

    private void writeLine(String id, BufferedWriter writer) throws IOException {
        writer.write(35);
        writer.write(id);
        writer.newLine();
    }
}

