/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.precommithook;

import com.syntevo.openapi.deprecated.log.Logger;
import com.syntevo.openapi.deprecated.log.LoggerFactory;
import com.syntevo.openapi.deprecated.smartsvn.command.SvnClients;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.CommitItem;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.CommitPacket;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.ICommitPreCommandPhase;
import com.syntevo.openapi.deprecated.util.PluginException;
import com.syntevo.plugin.precommithook.PreCommitHookStreamGobbler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.subversion.javahl.SubversionException;

class PreCommitHookCommitPhase
implements ICommitPreCommandPhase {
    private static final Logger LOG = LoggerFactory.createLogger((String)"com.syntevo.commitTemplate");
    private final ICommitPreCommandPhase wrappedPhase;
    private final File preCommitHook;

    public PreCommitHookCommitPhase(ICommitPreCommandPhase wrappedPhase, File preCommitHook) {
        this.wrappedPhase = wrappedPhase;
        this.preCommitHook = preCommitHook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CommitPacket> process(List<CommitPacket> commitSets, SvnClients svnClients) throws SubversionException {
        commitSets = this.wrappedPhase.process(commitSets, svnClients);
        for (CommitPacket set : commitSets) {
            File pathsFile;
            File workingCopyRoot = set.getCommitRoot().getFile();
            try {
                pathsFile = File.createTempFile("smartsvn", null);
            }
            catch (IOException ex) {
                LOG.error(ex.getMessage());
                continue;
            }
            try {
                PreCommitHookCommitPhase.fillPathsFile(pathsFile, set);
                ProcessBuilder processBuilder = new ProcessBuilder(this.preCommitHook.getAbsolutePath(), pathsFile.getAbsolutePath());
                processBuilder.directory(workingCopyRoot);
                Process process = processBuilder.start();
                Semaphore threadWaiter = new Semaphore(0);
                PreCommitHookStreamGobbler stdoutGobbler = new PreCommitHookStreamGobbler("stdout", process.getInputStream(), threadWaiter);
                PreCommitHookStreamGobbler stderrGobbler = new PreCommitHookStreamGobbler("stderr", process.getErrorStream(), threadWaiter);
                new Thread(stdoutGobbler).start();
                new Thread(stderrGobbler).start();
                int retCode = process.waitFor();
                threadWaiter.acquire(2);
                if (retCode == 0) continue;
                throw new PluginException("Pre-commit hook '" + this.preCommitHook.getAbsolutePath() + "' failed with return code " + retCode + ".");
            }
            catch (IOException | InterruptedException ex) {
                LOG.error(ex.getMessage());
            }
            finally {
                if (pathsFile.delete()) continue;
                LOG.warn("Could not delete '" + pathsFile + "'.");
            }
        }
        return commitSets;
    }

    private static void fillPathsFile(File pathsFile, CommitPacket packet) throws IOException {
        try (PrintWriter writer = new PrintWriter(new FileWriter(pathsFile));){
            for (CommitItem item : packet.getItems()) {
                writer.println(item.getPath().getFile());
            }
        }
    }
}

