/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.removeemptydirectories;

import com.syntevo.openapi.deprecated.log.Logger;
import com.syntevo.openapi.deprecated.log.LoggerFactory;
import com.syntevo.openapi.deprecated.smartsvn.command.ISvnCommand;
import com.syntevo.openapi.deprecated.smartsvn.command.SvnClients;
import com.syntevo.openapi.deprecated.smartsvn.file.SvnDirectory;
import com.syntevo.openapi.deprecated.smartsvn.thread.ProgressViewer;
import com.syntevo.openapi.deprecated.util.PluginException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.subversion.javahl.ISVNClient;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.callback.StatusCallback;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Status;

final class REDSvnCommand
implements ISvnCommand {
    private static final Logger LOG = LoggerFactory.createLogger((String)REDSvnCommand.class.getName());
    private final SvnDirectory directory;

    public REDSvnCommand(SvnDirectory directory) {
        this.directory = directory;
    }

    public void perform(SvnClients svnClients, ProgressViewer progressViewer) throws SubversionException {
        LOG.info("Removing empty directories within " + this.directory.getPath());
        HashMap<File, List<File>> directoryToChildren = new HashMap<File, List<File>>();
        HashSet<File> removableDirectories = new HashSet<File>();
        REDSvnCommand.fillDirectoryToChildren(this.directory, directoryToChildren, removableDirectories, svnClients);
        List<File> emptyDirectories = REDSvnCommand.determineEmptyDirectories(directoryToChildren, removableDirectories);
        REDSvnCommand.removeEmptyDirectories(emptyDirectories, svnClients, progressViewer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillDirectoryToChildren(SvnDirectory directory, final Map<File, List<File>> directoryToChildren, final Set<File> removableDirectories, SvnClients svnClients) throws SubversionException {
        String baseLocation = directory.getPath().getFile().getPath();
        ISVNClient svnClient = svnClients.createClient();
        try {
            svnClient.status(baseLocation, Depth.infinity, false, true, true, false, null, new StatusCallback(){

                public void doStatus(String path, Status status) {
                    Status.Kind contentStatus;
                    File file = new File(status.getPath());
                    if (status.getNodeKind() == NodeKind.dir) {
                        ArrayList children = (ArrayList)directoryToChildren.get(file);
                        if (children == null) {
                            children = new ArrayList();
                            directoryToChildren.put(file, children);
                        }
                        if (REDSvnCommand.isRemovableDirectory(status)) {
                            removableDirectories.add(file);
                        }
                    }
                    if ((contentStatus = status.getTextStatus()) == Status.Kind.deleted) {
                        return;
                    }
                    File parent = file.getParentFile();
                    if (parent == null) {
                        return;
                    }
                    ArrayList<File> children = (ArrayList<File>)directoryToChildren.get(parent);
                    if (children == null) {
                        children = new ArrayList<File>();
                        directoryToChildren.put(parent, children);
                    }
                    children.add(file);
                }
            });
        }
        finally {
            svnClient.dispose();
        }
    }

    private static List<File> determineEmptyDirectories(Map<File, List<File>> directoryToChildren, Set<File> removableDirectories) {
        ArrayList<File> emptyDirectories = new ArrayList<File>();
        boolean continu = true;
        while (continu) {
            continu = false;
            for (File directory : new HashSet<File>(directoryToChildren.keySet())) {
                if (directoryToChildren.get(directory).size() > 0 || !removableDirectories.contains(directory)) continue;
                emptyDirectories.add(directory);
                directoryToChildren.remove(directory);
                List<File> parentChildren = directoryToChildren.get(directory.getParentFile());
                if (parentChildren == null) continue;
                parentChildren.remove(directory);
                continu = true;
            }
        }
        return emptyDirectories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeEmptyDirectories(List<File> emptyDirectories, SvnClients svnClients, ProgressViewer progressViewer) throws SubversionException {
        Collections.sort(emptyDirectories, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
            }
        });
        Collections.reverse(emptyDirectories);
        ISVNClient svnClient = svnClients.createClient();
        try {
            for (int index = 0; index < emptyDirectories.size(); ++index) {
                final File directory = emptyDirectories.get(index);
                String directoryPath = directory.getAbsolutePath();
                progressViewer.setProgress(index, emptyDirectories.size());
                progressViewer.setMessage("Processing " + directory);
                final boolean[] removed = new boolean[1];
                try {
                    svnClient.status(directoryPath, Depth.immediates, false, true, true, false, null, new StatusCallback(){

                        public void doStatus(String path, Status status) {
                            Status.Kind contentStatus = status.getTextStatus();
                            File file = new File(status.getPath());
                            if (file.equals(directory)) {
                                if (!REDSvnCommand.isRemovableDirectory(status)) {
                                    throw PluginException.createWrappedRuntimeException((String)("Directory '" + directory + "' is modified."));
                                }
                                removed[0] = contentStatus == Status.Kind.deleted;
                                return;
                            }
                            if (contentStatus != Status.Kind.deleted) {
                                throw PluginException.createWrappedRuntimeException((String)("Directory '" + directory + "' is not empty now, but was before."));
                            }
                        }
                    });
                }
                catch (RuntimeException rex) {
                    if (rex.getCause() instanceof PluginException) {
                        throw (PluginException)rex.getCause();
                    }
                    throw rex;
                }
                if (removed[0]) continue;
                LOG.info("Scheduling empty directory " + directoryPath + " for removal.");
                svnClient.remove(Collections.singleton(directoryPath), false, false, null, null, null);
            }
        }
        finally {
            svnClient.dispose();
        }
    }

    private static boolean isRemovableDirectory(Status status) {
        if (status.getNodeKind() != NodeKind.dir) {
            return false;
        }
        Status.Kind contentsStatus = status.getTextStatus();
        Status.Kind propertiesStatus = status.getPropStatus();
        return contentsStatus == Status.Kind.deleted || contentsStatus == Status.Kind.normal && (propertiesStatus == Status.Kind.none || propertiesStatus == Status.Kind.normal);
    }
}

